/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

class MathTransformParser
extends AbstractParser {
    static final String[] ID_KEYWORDS = new String[]{"Id", "Authority"};
    private static final String[] UNIT_KEYWORDS = new String[]{"Unit", "LengthUnit", "AngleUnit", "ScaleUnit", "TimeUnit", "ParametricUnit"};
    private static final Unit<?>[] BASE_UNITS = new Unit[]{SI.METRE, SI.RADIAN, Unit.ONE, SI.SECOND};
    final MathTransformFactory mtFactory;
    private transient String classification;
    private transient OperationMethod lastMethod;

    public MathTransformParser(MathTransformFactory mtFactory) {
        this(Symbols.getDefault(), Collections.emptyMap(), null, null, null, mtFactory, null);
    }

    MathTransformParser(Symbols symbols, Map<String, Element> fragments, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, MathTransformFactory mtFactory, Locale errorLocale) {
        super(symbols, fragments, numberFormat, dateFormat, unitFormat, errorLocale);
        this.mtFactory = mtFactory;
        ArgumentChecks.ensureNonNull("mtFactory", mtFactory);
    }

    @Override
    String getPublicFacade() {
        return "org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory";
    }

    @Override
    Object parseObject(Element element) throws ParseException {
        return this.parseMathTransform(element, true);
    }

    final MathTransform parseMathTransform(Element element, boolean mandatory) throws ParseException {
        this.lastMethod = null;
        this.classification = null;
        MathTransform tr = this.parseParamMT(element);
        if (tr == null && (tr = this.parseConcatMT(element)) == null && (tr = this.parseInverseMT(element)) == null && (tr = this.parsePassThroughMT(element)) == null && mandatory) {
            throw element.missingOrUnknownComponent("Param_MT");
        }
        return tr;
    }

    final Unit<?> parseUnitID(Element parent) throws ParseException {
        Element element = parent.pullElement(1, ID_KEYWORDS);
        if (element != null) {
            String codeSpace = element.pullString("codeSpace");
            Object code = element.pullObject("code");
            element.close(this.ignoredElements);
            if ("EPSG".equalsIgnoreCase(codeSpace)) {
                try {
                    int n = Numbers.isInteger(code.getClass()) ? ((Number)code).intValue() : Integer.parseInt(code.toString());
                    return Units.valueOfEPSG(n);
                }
                catch (NumberFormatException e) {
                    this.warning(parent, element, null, (Exception)e);
                }
            }
        }
        return null;
    }

    final Unit<?> parseUnit(Element parent) throws ParseException {
        Element element = parent.pullElement(1, UNIT_KEYWORDS);
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        double factor = element.pullDouble("factor");
        int index = element.getKeywordIndex() - 1;
        Unit<?> unit = this.parseUnitID(element);
        element.close(this.ignoredElements);
        if (unit != null) {
            return unit;
        }
        if (index >= 0 && index < BASE_UNITS.length) {
            return Units.multiply(BASE_UNITS[index], factor);
        }
        try {
            return this.parseUnit(name);
        }
        catch (IllegalArgumentException e) {
            throw (ParseException)new LocalizedParseException(this.errorLocale, 211, new Object[]{name}, element.offset).initCause(e);
        }
    }

    final void parseParameters(Element element, ParameterValueGroup parameters, Unit<?> defaultUnit, Unit<Angle> defaultAngularUnit) throws ParseException {
        Unit<?> defaultSI = defaultUnit != null ? defaultUnit.toSI() : null;
        Element param = element;
        try {
            while ((param = element.pullElement(1, "Parameter")) != null) {
                String name = param.pullString("name");
                Unit<Object> unit = this.parseUnit(param);
                param.pullElement(1, ID_KEYWORDS);
                ParameterValue<?> parameter = parameters.parameter(name);
                ParameterDescriptor<?> descriptor = parameter.getDescriptor();
                Class<?> valueClass = descriptor.getValueClass();
                boolean isNumeric = Number.class.isAssignableFrom(valueClass);
                if (isNumeric && unit == null && (unit = descriptor.getUnit()) != null) {
                    Unit<?> si = unit.toSI();
                    if (si.equals(defaultSI)) {
                        unit = defaultUnit;
                    } else if (si.equals(SI.RADIAN)) {
                        unit = defaultAngularUnit;
                    }
                }
                if (unit != null) {
                    parameter.setValue(param.pullDouble("doubleValue"), unit);
                } else if (isNumeric) {
                    if (Numbers.isInteger(valueClass)) {
                        parameter.setValue(param.pullInteger("intValue"));
                    } else {
                        parameter.setValue(param.pullDouble("doubleValue"));
                    }
                } else if (valueClass == Boolean.class) {
                    parameter.setValue(param.pullBoolean("booleanValue"));
                } else {
                    parameter.setValue(param.pullString("stringValue"));
                }
                param.close(this.ignoredElements);
            }
        }
        catch (ParameterNotFoundException e) {
            throw (ParseException)new LocalizedParseException(this.errorLocale, 152, new String[]{e.getParameterName()}, param.offset).initCause(e);
        }
        catch (InvalidParameterValueException e) {
            throw (ParseException)new ParseException(e.getLocalizedMessage(), param.offset).initCause(e);
        }
    }

    private MathTransform parseParamMT(Element parent) throws ParseException {
        MathTransform transform;
        ParameterValueGroup parameters;
        Element element = parent.pullElement(0, "Param_MT");
        if (element == null) {
            return null;
        }
        this.classification = element.pullString("classification");
        try {
            parameters = this.mtFactory.getDefaultParameters(this.classification);
        }
        catch (NoSuchIdentifierException exception) {
            throw element.parseFailed(exception);
        }
        this.parseParameters(element, parameters, null, null);
        element.close(this.ignoredElements);
        try {
            transform = this.mtFactory.createParameterizedTransform(parameters);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
        this.lastMethod = this.mtFactory.getLastMethodUsed();
        return transform;
    }

    private MathTransform parseInverseMT(Element parent) throws ParseException {
        Element element = parent.pullElement(0, "Inverse_MT");
        if (element == null) {
            return null;
        }
        MathTransform transform = this.parseMathTransform(element, true);
        try {
            transform = transform.inverse();
        }
        catch (NoninvertibleTransformException exception) {
            throw element.parseFailed(exception);
        }
        element.close(this.ignoredElements);
        return transform;
    }

    private MathTransform parsePassThroughMT(Element parent) throws ParseException {
        Element element = parent.pullElement(0, "PassThrough_MT");
        if (element == null) {
            return null;
        }
        int firstAffectedOrdinate = parent.pullInteger("firstAffectedOrdinate");
        MathTransform transform = this.parseMathTransform(element, true);
        element.close(this.ignoredElements);
        try {
            return this.mtFactory.createPassThroughTransform(firstAffectedOrdinate, transform, 0);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception);
        }
    }

    private MathTransform parseConcatMT(Element parent) throws ParseException {
        MathTransform optionalTransform;
        Element element = parent.pullElement(0, "Concat_MT");
        if (element == null) {
            return null;
        }
        MathTransform transform = this.parseMathTransform(element, true);
        while ((optionalTransform = this.parseMathTransform(element, false)) != null) {
            try {
                transform = this.mtFactory.createConcatenatedTransform(transform, optionalTransform);
            }
            catch (FactoryException exception) {
                throw element.parseFailed(exception);
            }
        }
        element.close(this.ignoredElements);
        return transform;
    }

    final OperationMethod getOperationMethod() {
        if (this.lastMethod == null && this.classification != null) {
            this.lastMethod = ReferencingServices.getInstance().getOperationMethod(this.mtFactory.getAvailableMethods(SingleOperation.class), this.classification);
        }
        return this.lastMethod;
    }
}

