/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.util.Iterator;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class CompoundDirectPositions
implements DirectPosition,
Iterable<DirectPosition>,
Iterator<DirectPosition> {
    private final double[][] ordinates;
    private final int last;
    private int index;

    CompoundDirectPositions(double[] ... ordinates) {
        this.ordinates = ordinates;
        int length = ordinates[0].length;
        for (int i = 1; i < ordinates.length; ++i) {
            if (ordinates[i].length == length) continue;
            throw new IllegalArgumentException(Errors.format((short)56));
        }
        this.last = length - 1;
    }

    @Override
    public Iterator<DirectPosition> iterator() {
        this.index = -1;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.last;
    }

    @Override
    public DirectPosition next() {
        ++this.index;
        return this;
    }

    @Override
    public DirectPosition getDirectPosition() {
        return this;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    @Override
    public int getDimension() {
        return this.ordinates.length;
    }

    @Override
    public double getOrdinate(int dimension) {
        return this.ordinates[dimension][this.index];
    }

    @Override
    public double[] getCoordinate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOrdinate(int dimension, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

