/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.util.EnumSet;
import java.util.Set;

public enum FunctionProperty {
    INVERTIBLE,
    INJECTIVE,
    SURJECTIVE,
    ORDER_PRESERVING,
    ORDER_REVERSING;

    private static final EnumSet<FunctionProperty> BIJECTIVE;

    public static boolean isBijective(Set<FunctionProperty> properties) {
        return properties.containsAll(BIJECTIVE);
    }

    public static boolean isMonotonic(Set<FunctionProperty> properties) {
        return properties.contains((Object)ORDER_PRESERVING) || properties.contains((Object)ORDER_REVERSING);
    }

    static {
        BIJECTIVE = EnumSet.of(INJECTIVE, SURJECTIVE);
    }
}

