/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.util.Arrays;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class MathFunctions
extends Static {
    public static final double SQRT_2 = 1.4142135623730951;
    public static final double LOG10_2 = 0.3010299956639812;
    private static final int MIN_NAN_ORDINAL = -2097152;
    static final int MAX_NAN_ORDINAL = 0x1FFFFF;
    public static final int HIGHEST_SUPPORTED_PRIME_NUMBER = 65521;
    static final int PRIMES_LENGTH_15_BITS = 3512;
    static final int PRIMES_LENGTH_16_BITS = 6542;
    private static volatile short[] primes = new short[]{2, 3};

    private MathFunctions() {
    }

    public static double truncate(double value) {
        return (Double.doubleToRawLongBits(value) & Long.MIN_VALUE) == 0L ? Math.floor(value) : Math.ceil(value);
    }

    public static double magnitude(double ... vector) {
        double v3;
        double v2;
        double v1;
        int i = vector.length;
        do {
            if (i != 0) continue;
            return 0.0;
        } while ((v1 = vector[--i]) == 0.0);
        do {
            if (i != 0) continue;
            return Math.abs(v1);
        } while ((v2 = vector[--i]) == 0.0);
        do {
            if (i != 0) continue;
            return Math.hypot(v1, v2);
        } while ((v3 = vector[--i]) == 0.0);
        DoubleDouble sum = new DoubleDouble();
        DoubleDouble dot = new DoubleDouble();
        sum.setToProduct(v1, v1);
        dot.setToProduct(v2, v2);
        sum.add(dot);
        dot.setToProduct(v3, v3);
        sum.add(dot);
        while (i != 0) {
            v1 = vector[--i];
            dot.setToProduct(v1, v1);
            sum.add(dot);
        }
        sum.sqrt();
        return sum.value;
    }

    public static int getExponent(double value) {
        long bits = Double.doubleToRawLongBits(value);
        int exponent = (int)(bits >>> 52 & 0x7FFL);
        if (exponent == 0) {
            exponent -= Long.numberOfLeadingZeros(bits & 0xFFFFFFFFFFFFFL) - 12;
        }
        return exponent - 1023;
    }

    public static double pow10(double x) {
        int ix = (int)x;
        if ((double)ix == x) {
            return DecimalFunctions.pow10(ix);
        }
        return Math.pow(10.0, x);
    }

    public static double pow10(int x) {
        return DecimalFunctions.pow10(x);
    }

    public static double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double acosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    public static double atanh(double x) {
        return 0.5 * Math.log1p(2.0 * x / (1.0 - x));
    }

    public static boolean isPositive(double value) {
        return (Double.doubleToRawLongBits(value) & Long.MIN_VALUE) == 0L && !Double.isNaN(value);
    }

    public static boolean isPositiveZero(double value) {
        return Double.doubleToRawLongBits(value) == 0L;
    }

    public static boolean isNegative(double value) {
        return (Double.doubleToRawLongBits(value) & Long.MIN_VALUE) != 0L && !Double.isNaN(value);
    }

    public static boolean isNegativeZero(double value) {
        return Double.doubleToRawLongBits(value) == Long.MIN_VALUE;
    }

    public static boolean isSameSign(double v1, double v2) {
        return !Double.isNaN(v1) && !Double.isNaN(v2) && ((Double.doubleToRawLongBits(v1) ^ Double.doubleToRawLongBits(v2)) & Long.MIN_VALUE) == 0L;
    }

    public static double xorSign(double value, double sign) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(value) ^ Double.doubleToRawLongBits(sign) & Long.MIN_VALUE);
    }

    public static boolean epsilonEqual(float v1, float v2, float \u03b5) {
        return Math.abs(v1 - v2) <= \u03b5 || Float.floatToIntBits(v1) == Float.floatToIntBits(v2);
    }

    public static boolean epsilonEqual(double v1, double v2, double \u03b5) {
        return Math.abs(v1 - v2) <= \u03b5 || Double.doubleToLongBits(v1) == Double.doubleToLongBits(v2);
    }

    public static float toNanFloat(int ordinal) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween("ordinal", -2097152, 0x1FFFFF, ordinal);
        float value = Float.intBitsToFloat(2143289344 + ordinal);
        assert (Float.isNaN(value) && MathFunctions.toNanOrdinal(value) == ordinal) : ordinal;
        return value;
    }

    public static int toNanOrdinal(float value) throws IllegalArgumentException {
        Object obj;
        short resourceKey;
        int ordinal = Float.floatToRawIntBits(value) - 2143289344;
        if (ordinal >= -2097152 && ordinal <= 0x1FFFFF) {
            return ordinal;
        }
        if (Float.isNaN(value)) {
            resourceKey = 33;
            obj = Integer.toHexString(ordinal);
        } else {
            resourceKey = 31;
            obj = Float.valueOf(value);
        }
        throw new IllegalArgumentException(Errors.format(resourceKey, obj));
    }

    public static double quadrupleToDouble(long l0, long l1) {
        long sig = l0 & Long.MIN_VALUE;
        long exp = (l0 & 0x7FFF000000000000L) >> 48;
        l0 &= 0xFFFFFFFFFFFFL;
        if (exp == 0L) {
            return Double.longBitsToDouble(sig);
        }
        if (exp == 32767L) {
            if (l0 == 0L && l1 == 0L) {
                return Double.longBitsToDouble(sig | 0x7FF0000000000000L);
            }
            return Double.NaN;
        }
        if ((exp -= 15360L) < 0L) {
            return Double.NEGATIVE_INFINITY;
        }
        if (exp > 2046L) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.longBitsToDouble(sig | exp << 52 | l0 << 4 | l1 >>> 60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int primeNumberAt(int index) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(6542, index);
        short[] primes = MathFunctions.primes;
        if (index < primes.length) return primes[index] & 0xFFFF;
        Class<MathFunctions> clazz = MathFunctions.class;
        synchronized (MathFunctions.class) {
            primes = MathFunctions.primes;
            if (index < primes.length) return primes[index] & 0xFFFF;
            int i = primes.length;
            int n = primes[i - 1] & 0xFFFF;
            primes = Arrays.copyOf(primes, Math.min((index | 0xF) + 1, 6542));
            block3: while (true) {
                int prime;
                int stopAt = (int)Math.sqrt(n += 2);
                int j = 0;
                do {
                    if (n % (prime = primes[++j] & 0xFFFF) == 0) continue block3;
                } while (prime <= stopAt);
                primes[i] = (short)n;
                if (++i >= primes.length) break;
            }
            MathFunctions.primes = primes;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return primes[index] & 0xFFFF;
        }
    }

    public static int nextPrimeNumber(int number) throws IllegalArgumentException {
        int i;
        ArgumentChecks.ensureBetween("number", 2, 65521, number);
        short[] primes = MathFunctions.primes;
        int lower = 0;
        int upper = Math.min(3512, primes.length);
        if (number > Short.MAX_VALUE) {
            lower = upper;
            upper = primes.length;
        }
        if ((i = Arrays.binarySearch(primes, lower, upper, (short)number)) < 0 && (i ^= 0xFFFFFFFF) >= primes.length) {
            int p;
            while ((p = MathFunctions.primeNumberAt(i++)) < number) {
            }
            return p;
        }
        return primes[i] & 0xFFFF;
    }

    public static int[] divisors(int number) {
        int d2;
        int d1;
        int p;
        if (number == 0) {
            return ArraysExt.EMPTY_INT;
        }
        number = Math.abs(number);
        int[] divisors = new int[16];
        divisors[0] = 1;
        int count = 1;
        int sqrt = (int)Math.sqrt(number);
        int i = 0;
        while ((p = MathFunctions.primeNumberAt(i)) <= sqrt) {
            if (number % p == 0) {
                if (count == divisors.length) {
                    divisors = Arrays.copyOf(divisors, count * 2);
                }
                divisors[count++] = p;
            }
            ++i;
        }
        int source = count;
        if (count * 2 > divisors.length) {
            divisors = Arrays.copyOf(divisors, count * 2);
        }
        if ((d1 = divisors[--source]) != (d2 = number / d1)) {
            divisors[count++] = d2;
        }
        while (--source >= 0) {
            divisors[count++] = number / divisors[source];
        }
        for (int i2 = 1; i2 < count; ++i2) {
            d1 = divisors[i2];
            for (int j = i2; j < count; ++j) {
                int p2;
                d2 = d1 * divisors[j];
                if (number % d2 != 0 || (p2 = Arrays.binarySearch(divisors, j, count, d2)) >= 0) continue;
                p2 ^= 0xFFFFFFFF;
                if (count == divisors.length) {
                    divisors = Arrays.copyOf(divisors, count * 2);
                }
                System.arraycopy(divisors, p2, divisors, p2 + 1, count - p2);
                divisors[p2] = d2;
                ++count;
            }
        }
        divisors = ArraysExt.resize(divisors, count);
        assert (ArraysExt.isSorted(divisors, true));
        return divisors;
    }

    public static int[] commonDivisors(int ... numbers) {
        if (numbers.length == 0) {
            return ArraysExt.EMPTY_INT;
        }
        int minValue = Integer.MAX_VALUE;
        for (int i = 0; i < numbers.length; ++i) {
            int n = Math.abs(numbers[i]);
            if (n > minValue) continue;
            minValue = n;
        }
        int[] divisors = MathFunctions.divisors(minValue);
        int count = divisors.length;
        for (int i = 0; i < numbers.length; ++i) {
            int n = Math.abs(numbers[i]);
            if (n == minValue) continue;
            int j = count;
            while (--j > 0) {
                if (n % divisors[j] == 0) continue;
                System.arraycopy(divisors, j + 1, divisors, j, --count - j);
            }
        }
        return ArraysExt.resize(divisors, count);
    }
}

