/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.CompoundDirectPositions;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;

public class Plane
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2956201711131316723L;
    private static final int DIMENSION = 3;
    private static final double ZERO_THRESHOLD = 1.0E-14;
    private double sx;
    private double sy;
    private double z0;

    public Plane() {
        this.z0 = Double.NaN;
        this.sy = Double.NaN;
        this.sx = Double.NaN;
    }

    public Plane(double sx, double sy, double z0) {
        this.sx = sx;
        this.sy = sy;
        this.z0 = z0;
    }

    public final double slopeX() {
        return this.sx;
    }

    public final double slopeY() {
        return this.sy;
    }

    public final double z0() {
        return this.z0;
    }

    public final double x(double y, double z) {
        return (z - (this.z0 + this.sy * y)) / this.sx;
    }

    public final double y(double x, double z) {
        return (z - (this.z0 + this.sx * x)) / this.sy;
    }

    public final double z(double x, double y) {
        return this.z0 + this.sx * x + this.sy * y;
    }

    public void setEquation(double sx, double sy, double z0) {
        this.sx = sx;
        this.sy = sy;
        this.z0 = z0;
    }

    public double fit(double[] x, double[] y, double[] z) {
        return this.fit(new CompoundDirectPositions(x, y, z), true, true, true);
    }

    public double fit(Iterable<? extends DirectPosition> points) {
        return this.fit(points, true, true, true);
    }

    private double fit(Iterable<? extends DirectPosition> points, boolean detectZeroSx, boolean detectZeroSy, boolean detectZeroZ0) {
        int i = 0;
        int n = 0;
        DoubleDouble sum_x = new DoubleDouble();
        DoubleDouble sum_y = new DoubleDouble();
        DoubleDouble sum_z = new DoubleDouble();
        DoubleDouble sum_xx = new DoubleDouble();
        DoubleDouble sum_yy = new DoubleDouble();
        DoubleDouble sum_xy = new DoubleDouble();
        DoubleDouble sum_zx = new DoubleDouble();
        DoubleDouble sum_zy = new DoubleDouble();
        DoubleDouble xx = new DoubleDouble();
        DoubleDouble yy = new DoubleDouble();
        DoubleDouble xy = new DoubleDouble();
        DoubleDouble zx = new DoubleDouble();
        DoubleDouble zy = new DoubleDouble();
        for (DirectPosition directPosition : points) {
            double z;
            double y;
            int dimension = directPosition.getDimension();
            if (dimension != 3) {
                throw new MismatchedDimensionException(Errors.format((short)59, "points[" + i + ']', 3, dimension));
            }
            ++i;
            double x = directPosition.getOrdinate(0);
            if (Double.isNaN(x) || Double.isNaN(y = directPosition.getOrdinate(1)) || Double.isNaN(z = directPosition.getOrdinate(2))) continue;
            xx.setToProduct(x, x);
            yy.setToProduct(y, y);
            xy.setToProduct(x, y);
            zx.setToProduct(z, x);
            zy.setToProduct(z, y);
            sum_x.add(x);
            sum_y.add(y);
            sum_z.add(z);
            sum_xx.add(xx);
            sum_yy.add(yy);
            sum_xy.add(xy);
            sum_zx.add(zx);
            sum_zy.add(zy);
            ++n;
        }
        zx.setFrom(sum_x);
        zx.divide(-n, 0.0);
        zx.multiply(sum_z);
        zx.add(sum_zx);
        zy.setFrom(sum_y);
        zy.divide(-n, 0.0);
        zy.multiply(sum_z);
        zy.add(sum_zy);
        xx.setFrom(sum_x);
        xx.divide(-n, 0.0);
        xx.multiply(sum_x);
        xx.add(sum_xx);
        xy.setFrom(sum_y);
        xy.divide(-n, 0.0);
        xy.multiply(sum_x);
        xy.add(sum_xy);
        yy.setFrom(sum_y);
        yy.divide(-n, 0.0);
        yy.multiply(sum_y);
        yy.add(sum_yy);
        DoubleDouble tmp = new DoubleDouble(xx);
        tmp.multiply(yy);
        DoubleDouble doubleDouble = new DoubleDouble(xy);
        doubleDouble.multiply(xy);
        doubleDouble.subtract(tmp);
        DoubleDouble sx = new DoubleDouble(zy);
        sx.multiply(xy);
        tmp.setFrom(zx);
        tmp.multiply(yy);
        sx.subtract(tmp);
        sx.divide(doubleDouble);
        DoubleDouble sy = new DoubleDouble(zx);
        sy.multiply(xy);
        tmp.setFrom(zy);
        tmp.multiply(xx);
        sy.subtract(tmp);
        sy.divide(doubleDouble);
        DoubleDouble z0 = new DoubleDouble(sy);
        z0.multiply(sum_y);
        tmp.setFrom(sx);
        tmp.multiply(sum_x);
        tmp.add(z0);
        z0.setFrom(sum_z);
        z0.subtract(tmp);
        z0.divide(n, 0.0);
        double mean_x = sum_x.value / (double)n;
        double mean_y = sum_y.value / (double)n;
        double mean_z = sum_z.value / (double)n;
        double offset = Math.abs(sx.value * mean_x + sy.value * mean_y + z0.value);
        double sum_ds2 = 0.0;
        double sum_dz2 = 0.0;
        double sum_dsz = 0.0;
        for (DirectPosition directPosition : points) {
            double x = (directPosition.getOrdinate(0) - mean_x) * sx.value;
            double y = (directPosition.getOrdinate(1) - mean_y) * sy.value;
            double z = directPosition.getOrdinate(2) - mean_z;
            double s = x + y;
            if (!Double.isNaN(s) && !Double.isNaN(z)) {
                sum_ds2 += s * s;
                sum_dz2 += z * z;
                sum_dsz += s * z;
            }
            if (detectZeroSx && Math.abs(x) >= Math.ulp(y * 1.0E-14)) {
                detectZeroSx = false;
            }
            if (detectZeroSy && Math.abs(y) >= Math.ulp(x * 1.0E-14)) {
                detectZeroSy = false;
            }
            if (!detectZeroZ0 || !(offset >= Math.ulp(s * 1.0E-14))) continue;
            detectZeroZ0 = false;
        }
        this.setEquation(detectZeroSx ? 0.0 : sx.value, detectZeroSy ? 0.0 : sy.value, detectZeroZ0 ? 0.0 : z0.value);
        return Math.min(sum_dsz / Math.sqrt(sum_ds2 * sum_dz2), 1.0);
    }

    public Plane clone() {
        try {
            return (Plane)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            Plane that = (Plane)object;
            return Numerics.equals(this.z0, that.z0) && Numerics.equals(this.sx, that.sx) && Numerics.equals(this.sy, that.sy);
        }
        return false;
    }

    public int hashCode() {
        return Numerics.hashCode(0x290689CB2C6251F3L ^ Double.doubleToLongBits(this.z0) + 31L * (Double.doubleToLongBits(this.sx) + 31L * Double.doubleToLongBits(this.sy)));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(60).append("z(x,y) = ");
        String separator = "";
        if (this.sx != 0.0) {
            buffer.append(this.sx).append("\u22c5x");
            separator = " + ";
        }
        if (this.sy != 0.0) {
            buffer.append(separator).append(this.sy).append("\u22c5y");
            separator = " + ";
        }
        return buffer.append(separator).append(this.z0).toString();
    }
}

