/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

public class StatisticsFormat
extends TabularFormat<Statistics> {
    private static final long serialVersionUID = 6914760410359494163L;
    private static final int ADDITIONAL_DIGITS = 2;
    private final Locale headerLocale;
    private byte borderWidth;
    private boolean allPopulation;
    private static final short[] KEYS = new short[]{39, 38, 35, 33, 34, 48, 51};

    public static StatisticsFormat getInstance() {
        return StatisticsFormat.getInstance(Locale.getDefault());
    }

    public static StatisticsFormat getInstance(Locale locale) {
        return new StatisticsFormat(locale, locale, null);
    }

    public StatisticsFormat(Locale locale, Locale headerLocale, TimeZone timezone) {
        super(locale, timezone);
        this.headerLocale = headerLocale != null ? headerLocale : Locale.ROOT;
    }

    @Override
    public final Class<Statistics> getValueType() {
        return Statistics.class;
    }

    public boolean isForAllPopulation() {
        return this.allPopulation;
    }

    public void setForAllPopulation(boolean allPopulation) {
        this.allPopulation = allPopulation;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        ArgumentChecks.ensureBetween("borderWidth", 0, 2, borderWidth);
        this.borderWidth = (byte)borderWidth;
    }

    @Override
    public Statistics parse(CharSequence text, ParsePosition pos) throws ParseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer format(Object object, StringBuffer toAppendTo, FieldPosition pos) {
        if (object instanceof Statistics[]) {
            try {
                this.format((Statistics[])object, (Appendable)toAppendTo);
                return toAppendTo;
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
        }
        return super.format(object, toAppendTo, pos);
    }

    @Override
    public void format(Statistics stats, Appendable toAppendTo) throws IOException {
        ArrayList<Statistics> list = new ArrayList<Statistics>(3);
        while (stats != null) {
            list.add(stats);
            stats = stats.differences();
        }
        this.format(list.toArray(new Statistics[list.size()]), toAppendTo);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void format(Statistics[] stats, Appendable toAppendTo) throws IOException {
        Format format;
        String[] headers = new String[stats.length];
        boolean showHeaders = false;
        boolean showNaNCount = false;
        for (int i = 0; i < stats.length; ++i) {
            Statistics s = stats[i];
            showNaNCount |= s.countNaN() != 0;
            InternationalString header = s.name();
            if (header == null) continue;
            headers[i] = header.toString(this.headerLocale);
            showHeaders |= headers[i] != null;
        }
        char horizontalLine = '\u0000';
        String separator = this.columnSeparator;
        switch (this.borderWidth) {
            case 1: {
                horizontalLine = '\u2500';
                separator = separator + "\u2502 ";
                break;
            }
            case 2: {
                horizontalLine = '\u2550';
                separator = separator + "\u2551 ";
                break;
            }
        }
        TableAppender table = new TableAppender(toAppendTo, separator);
        Vocabulary resources = Vocabulary.getResources(this.headerLocale);
        if (horizontalLine != '\u0000') {
            table.nextLine(horizontalLine);
        }
        if (showHeaders) {
            table.nextColumn();
            for (String header : headers) {
                if (header != null) {
                    table.append(header);
                    table.setCellAlignment((byte)0);
                }
                table.nextColumn();
            }
            table.append(this.lineSeparator);
            if (horizontalLine != '\u0000') {
                table.nextLine(horizontalLine);
            }
        }
        if ((format = this.getFormat(Double.class)) instanceof DecimalFormat) {
            ((DecimalFormat)format).applyPattern("#0");
        } else if (format instanceof NumberFormat) {
            StatisticsFormat.setFractionDigits((NumberFormat)format, 0);
        }
        boolean needsConfigure = false;
        block20: for (int i = 0; i < KEYS.length; ++i) {
            switch (i) {
                case 1: {
                    if (showNaNCount) break;
                    continue block20;
                }
                case 2: {
                    needsConfigure = true;
                    break;
                }
                case 3: {
                    needsConfigure = stats[0].differences() != null;
                }
            }
            table.setCellAlignment((byte)-1);
            table.append(resources.getString(KEYS[i])).append(':');
            for (Statistics s : stats) {
                void var17_17;
                switch (i) {
                    case 0: {
                        Integer n = s.count();
                        break;
                    }
                    case 1: {
                        Integer n = s.countNaN();
                        break;
                    }
                    case 2: {
                        Double d = s.minimum();
                        break;
                    }
                    case 3: {
                        Double d = s.maximum();
                        break;
                    }
                    case 4: {
                        Double d = s.mean();
                        break;
                    }
                    case 5: {
                        Double d = s.rms();
                        break;
                    }
                    case 6: {
                        Double d = s.standardDeviation(this.allPopulation);
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
                if (needsConfigure) {
                    this.configure(format, s);
                }
                table.append(this.beforeFill);
                table.nextColumn(this.fillCharacter);
                table.append(format.format(var17_17));
                table.setCellAlignment((byte)1);
            }
            table.append(this.lineSeparator);
        }
        if (horizontalLine != '\u0000') {
            table.nextLine(horizontalLine);
        }
        table.flush();
    }

    private void configure(Format format, Statistics stats) {
        double minimum = stats.minimum();
        double maximum = stats.maximum();
        double extremum = Math.max(Math.abs(minimum), Math.abs(maximum));
        if ((extremum >= 1.0E10 || extremum <= 1.0E-4) && format instanceof DecimalFormat) {
            ((DecimalFormat)format).applyPattern("0.00000E00");
        } else {
            double mean = stats.mean();
            double delta = 2.0 * stats.standardDeviation(true);
            delta = Math.min(maximum, mean + delta) - Math.max(minimum, mean - delta);
            delta = Math.max(delta / (double)stats.count(), Math.ulp(extremum));
            if (format instanceof NumberFormat) {
                StatisticsFormat.setFractionDigits((NumberFormat)format, Math.max(0, 2 + DecimalFunctions.fractionDigitsForDelta(delta, false)));
            }
        }
    }

    private static void setFractionDigits(NumberFormat format, int digits) {
        format.setMinimumFractionDigits(digits);
        format.setMaximumFractionDigits(digits);
    }
}

