/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Locale;
import org.apache.sis.internal.util.Utilities;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AngleFormat;

public class Angle
implements Comparable<Angle>,
Formattable,
Serializable {
    private static final long serialVersionUID = 3701568577051191744L;
    private static Format format;
    private final double \u03b8;

    public Angle(double \u03b8) {
        this.\u03b8 = \u03b8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Angle(String string) throws NumberFormatException {
        Object angle;
        try {
            Class<Angle> clazz = Angle.class;
            synchronized (Angle.class) {
                angle = Angle.getAngleFormat().parseObject(string);
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        }
        catch (ParseException exception) {
            NumberFormatException e = new NumberFormatException(exception.getMessage());
            e.initCause(exception);
            throw e;
        }
        {
            Class<?> type = angle.getClass();
            if (type != Angle.class && !this.getClass().isAssignableFrom(type)) {
                throw new NumberFormatException(string);
            }
            this.\u03b8 = ((Angle)angle).\u03b8;
            return;
        }
    }

    public double degrees() {
        return this.\u03b8;
    }

    public double radians() {
        return Math.toRadians(this.\u03b8);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.\u03b8);
        return (int)code ^ (int)(code >>> 32) ^ 0x52E269C0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            return Double.doubleToLongBits(this.\u03b8) == Double.doubleToLongBits(((Angle)object).\u03b8);
        }
        return false;
    }

    @Override
    public int compareTo(Angle that) {
        return Double.compare(this.\u03b8, that.\u03b8);
    }

    double maximum() {
        return 360.0;
    }

    char hemisphere(boolean negative) {
        return '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        boolean isSmall;
        StringBuffer buffer = new StringBuffer();
        double m = Math.abs(this.\u03b8);
        boolean bl = isSmall = m <= 2.7777777777777776E-7;
        if (isSmall || m > this.maximum()) {
            char h = this.hemisphere(MathFunctions.isNegative(this.\u03b8));
            if (h == '\u0000') {
                m = this.\u03b8;
            }
            char symbol = '\u00b0';
            if (isSmall) {
                symbol = '\u2033';
                m *= 3600.0;
            }
            buffer.append(m).append(symbol);
            if (h == '\u0000') return buffer.toString();
            buffer.append(h);
            return buffer.toString();
        }
        Class<Angle> clazz = Angle.class;
        synchronized (Angle.class) {
            buffer = Angle.getAngleFormat().format(this, buffer, null);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return buffer.toString();
        }
    }

    private static Format getAngleFormat() {
        assert (Thread.holdsLock(Angle.class));
        if (format == null) {
            format = new AngleFormat(Locale.ROOT);
        }
        return format;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String value;
        if (precision == 0) {
            value = "";
        } else {
            char h;
            int w = precision;
            if (w > 0 && (h = this.hemisphere(MathFunctions.isNegative(this.\u03b8))) != '\u0000' && --w == 0) {
                value = Character.toString(h);
            } else {
                AngleFormat format = new AngleFormat(formatter.locale());
                if (w > 0) {
                    format.setMaximumWidth(w);
                }
                value = format.format(this, new StringBuffer(), null).toString();
            }
        }
        Utilities.formatTo(formatter, flags, width, precision, value);
    }
}

