/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.internal.simple.SimpleCharacterIterator;
import org.apache.sis.measure.FormatField;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;

final class FormattedCharacterIterator
extends SimpleCharacterIterator
implements AttributedCharacterIterator {
    private static final long serialVersionUID = -5864519830922231670L;
    private final Map<AttributedCharacterIterator.Attribute, Entry> attributes = new IdentityHashMap<AttributedCharacterIterator.Attribute, Entry>(8);
    private transient Set<AttributedCharacterIterator.Attribute> attributeKeys;
    private transient AttributedCharacterIterator.Attribute runAttribute;
    private transient int start;
    private transient int limit;
    private transient int validity;

    FormattedCharacterIterator(CharSequence text) {
        super(text);
    }

    final void addFieldLimit(AttributedCharacterIterator.Attribute field, Object value, int start) {
        this.upper = this.text.length();
        Entry e = new Entry(field, value, start, this.upper, this.attributes);
        assert ((e = e.previous) == null || start >= e.limit);
    }

    final void append(AttributedCharacterIterator it, StringBuffer toAppendTo) {
        int offset = toAppendTo.length();
        int currentRunLimit = 0;
        char c = it.first();
        while (c != '\uffff') {
            toAppendTo.append(c);
            if (it.getIndex() == currentRunLimit) {
                currentRunLimit = it.getRunLimit();
                for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : it.getAttributes().entrySet()) {
                    AttributedCharacterIterator.Attribute attribute = entry.getKey();
                    if (it.getRunLimit(attribute) != currentRunLimit) continue;
                    new Entry(attribute, entry.getValue(), offset + it.getRunStart(attribute), offset + currentRunLimit, this.attributes);
                }
            }
            c = it.next();
        }
        this.upper = toAppendTo.length();
    }

    private void update(AttributedCharacterIterator.Attribute attribute, Collection<Entry> entries) {
        int index = this.getIndex();
        if (attribute == null || attribute != this.runAttribute || index != this.validity) {
            this.runAttribute = attribute;
            this.validity = index;
            this.start = 0;
            this.limit = this.upper;
            if (entries == null) {
                entries = attribute == FormatField.ALL ? this.attributes.values() : Collections.singleton(this.attributes.get(attribute));
            }
            Iterator<Entry> iterator = entries.iterator();
            while (iterator.hasNext()) {
                Entry entry;
                Entry notFound = entry = iterator.next();
                while (entry != null) {
                    if (index >= entry.start && index < entry.limit) {
                        if (entry.start > this.start) {
                            this.start = entry.start;
                        }
                        if (entry.limit < this.limit) {
                            this.limit = entry.limit;
                        }
                        notFound = null;
                    }
                    entry = entry.previous;
                }
                while (notFound != null) {
                    if (notFound.start > index && notFound.start < this.limit) {
                        this.limit = notFound.start;
                    }
                    if (notFound.limit <= index && notFound.limit > this.start) {
                        this.start = notFound.limit;
                    }
                    notFound = notFound.previous;
                }
            }
        }
    }

    @Override
    public int getRunStart() {
        this.update(FormatField.ALL, null);
        return this.start;
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        ArgumentChecks.ensureNonNull("attribute", attribute);
        this.update(attribute, null);
        return this.start;
    }

    @Override
    public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
        this.update(null, this.entries(attributes));
        return this.start;
    }

    @Override
    public int getRunLimit() {
        this.update(FormatField.ALL, null);
        return this.limit;
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        ArgumentChecks.ensureNonNull("attribute", attribute);
        this.update(attribute, null);
        return this.limit;
    }

    @Override
    public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
        this.update(null, this.entries(attributes));
        return this.limit;
    }

    private Collection<Entry> entries(Set<? extends AttributedCharacterIterator.Attribute> requested) {
        ArrayList<Entry> entries = new ArrayList<Entry>(requested.size());
        for (AttributedCharacterIterator.Attribute attribute : requested) {
            Entry e = this.attributes.get(attribute);
            if (e == null) continue;
            entries.add(e);
        }
        return entries;
    }

    @Override
    public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
        int index = this.getIndex();
        return Containers.derivedMap(this.attributes, new Filter(this.attributes, index), new Selector(index));
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        int index = this.getIndex();
        Entry e = this.attributes.get(attribute);
        while (e != null) {
            if (index >= e.start && index < e.limit) {
                return e.value;
            }
            e = e.previous;
        }
        return null;
    }

    @Override
    public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
        if (this.attributeKeys == null) {
            this.attributeKeys = Collections.unmodifiableSet(this.attributes.keySet());
        }
        return this.attributeKeys;
    }

    private static class Filter
    extends SurjectiveConverter<AttributedCharacterIterator.Attribute, AttributedCharacterIterator.Attribute>
    implements Serializable {
        private static final long serialVersionUID = 6951804952836918035L;
        private final Map<AttributedCharacterIterator.Attribute, Entry> attributes;
        private final int index;

        Filter(Map<AttributedCharacterIterator.Attribute, Entry> attributes, int index) {
            this.attributes = attributes;
            this.index = index;
        }

        @Override
        public AttributedCharacterIterator.Attribute apply(AttributedCharacterIterator.Attribute attribute) {
            Entry e = this.attributes.get(attribute);
            while (e != null) {
                if (this.index >= e.start && this.index < e.limit) {
                    return attribute;
                }
                e = e.previous;
            }
            return null;
        }

        @Override
        public Class<AttributedCharacterIterator.Attribute> getSourceClass() {
            return AttributedCharacterIterator.Attribute.class;
        }

        @Override
        public Class<AttributedCharacterIterator.Attribute> getTargetClass() {
            return AttributedCharacterIterator.Attribute.class;
        }
    }

    private static final class Selector
    extends SurjectiveConverter<Entry, Object>
    implements Serializable {
        private static final long serialVersionUID = -7281235148346378214L;
        private final int index;

        Selector(int index) {
            this.index = index;
        }

        @Override
        public Object apply(Entry entry) {
            while (entry != null) {
                if (this.index >= entry.start && this.index < entry.limit) {
                    return entry.value;
                }
                entry = entry.previous;
            }
            return null;
        }

        @Override
        public Class<Entry> getSourceClass() {
            return Entry.class;
        }

        @Override
        public Class<Object> getTargetClass() {
            return Object.class;
        }
    }

    private static final class Entry {
        private static final long serialVersionUID = 3297480138621390486L;
        final Object value;
        final int start;
        final int limit;
        final Entry previous;

        Entry(AttributedCharacterIterator.Attribute field, Object value, int start, int limit, Map<AttributedCharacterIterator.Attribute, Entry> attributes) {
            this.value = value;
            this.start = start;
            this.limit = limit;
            this.previous = attributes.put(field, this);
        }
    }
}

