/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.resources.Errors;

public class NumberRange<E extends Number>
extends Range<E> {
    private static final long serialVersionUID = -3198281191274903617L;
    private static final WeakHashSet<NumberRange<?>> POOL = new WeakHashSet<NumberRange>(NumberRange.class);

    static <E extends Number, T extends NumberRange<E>> T unique(T range) {
        if (!range.isEmpty()) {
            range = POOL.unique(range);
        }
        return range;
    }

    public static NumberRange<Byte> create(byte minValue, boolean isMinIncluded, byte maxValue, boolean isMaxIncluded) {
        return NumberRange.unique(new NumberRange<Byte>(Byte.class, minValue, isMinIncluded, maxValue, isMaxIncluded));
    }

    public static NumberRange<Short> create(short minValue, boolean isMinIncluded, short maxValue, boolean isMaxIncluded) {
        return NumberRange.unique(new NumberRange<Short>(Short.class, minValue, isMinIncluded, maxValue, isMaxIncluded));
    }

    public static NumberRange<Integer> create(int minValue, boolean isMinIncluded, int maxValue, boolean isMaxIncluded) {
        return NumberRange.unique(new NumberRange<Integer>(Integer.class, minValue, isMinIncluded, maxValue, isMaxIncluded));
    }

    public static NumberRange<Long> create(long minValue, boolean isMinIncluded, long maxValue, boolean isMaxIncluded) {
        return NumberRange.unique(new NumberRange<Long>(Long.class, minValue, isMinIncluded, maxValue, isMaxIncluded));
    }

    public static NumberRange<Float> create(float minValue, boolean isMinIncluded, float maxValue, boolean isMaxIncluded) {
        return NumberRange.unique(new NumberRange<Float>(Float.class, NumberRange.valueOf("minValue", minValue, Float.NEGATIVE_INFINITY), isMinIncluded, NumberRange.valueOf("maxValue", maxValue, Float.POSITIVE_INFINITY), isMaxIncluded));
    }

    static Float valueOf(String name, float value, float infinity) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException(Errors.format((short)89, name));
        }
        return value != infinity ? Float.valueOf(value) : null;
    }

    public static NumberRange<Double> create(double minValue, boolean isMinIncluded, double maxValue, boolean isMaxIncluded) {
        return NumberRange.unique(new NumberRange<Double>(Double.class, NumberRange.valueOf("minValue", minValue, Double.NEGATIVE_INFINITY), isMinIncluded, NumberRange.valueOf("maxValue", maxValue, Double.POSITIVE_INFINITY), isMaxIncluded));
    }

    static Double valueOf(String name, double value, double infinity) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException(Errors.format((short)89, name));
        }
        return value != infinity ? Numerics.valueOf(value) : null;
    }

    public static NumberRange<Integer> createLeftBounded(int minValue, boolean isMinIncluded) {
        return NumberRange.unique(new NumberRange<Object>((Class<Object>)Integer.class, minValue, isMinIncluded, null, false));
    }

    public static NumberRange<?> createBestFit(Number minValue, boolean isMinIncluded, Number maxValue, boolean isMaxIncluded) {
        Class<? extends Number> type = Numbers.widestClass(Numbers.narrowestClass(minValue), Numbers.narrowestClass(maxValue));
        return type == null ? null : NumberRange.unique(new NumberRange<Number>(type, Numbers.cast(minValue, type), isMinIncluded, Numbers.cast(maxValue, type), isMaxIncluded));
    }

    public static <N extends Number> NumberRange<N> castOrCopy(Range<N> range) {
        if (range instanceof NumberRange) {
            return (NumberRange)range;
        }
        return new NumberRange<N>(range);
    }

    public NumberRange(Range<E> range) {
        super(range);
    }

    public NumberRange(Class<E> type, ValueRange range) throws IllegalArgumentException {
        super(type, (Comparable)Numbers.cast(NumberRange.valueOf("minimum", range.minimum(), Double.NEGATIVE_INFINITY), type), range.isMinIncluded(), (Comparable)Numbers.cast(NumberRange.valueOf("maximum", range.maximum(), Double.POSITIVE_INFINITY), type), range.isMaxIncluded());
    }

    public NumberRange(Class<E> type, E minValue, boolean isMinIncluded, E maxValue, boolean isMaxIncluded) {
        super(type, (Comparable)minValue, isMinIncluded, (Comparable)maxValue, isMaxIncluded);
    }

    NumberRange(Class<E> type, Range<? extends Number> range) throws IllegalArgumentException {
        super(type, (Comparable)Numbers.cast((Number)range.minValue, type), range.isMinIncluded, (Comparable)Numbers.cast((Number)range.maxValue, type), range.isMaxIncluded);
    }

    @Override
    Range<E> create(E minValue, boolean isMinIncluded, E maxValue, boolean isMaxIncluded) {
        return new NumberRange<E>(this.elementType, minValue, isMinIncluded, maxValue, isMaxIncluded);
    }

    <N extends Number> NumberRange<N> convertAndCast(NumberRange<?> range, Class<N> type) throws IllegalArgumentException {
        if (range.elementType == type) {
            return range;
        }
        return new NumberRange<N>(type, range);
    }

    public <N extends Number> NumberRange<N> castTo(Class<N> type) throws IllegalArgumentException {
        if (this.elementType == type) {
            return this;
        }
        return new NumberRange<N>(type, this);
    }

    @Override
    Range<E>[] newArray(int length) {
        return new NumberRange[length];
    }

    public double getMinDouble() {
        Number value = (Number)this.getMinValue();
        return value != null ? value.doubleValue() : Double.NEGATIVE_INFINITY;
    }

    public double getMinDouble(boolean inclusive) {
        double value = this.getMinDouble();
        if (inclusive != this.isMinIncluded()) {
            value = NumberRange.next(this.getElementType(), value, inclusive);
        }
        return value;
    }

    public double getMaxDouble() {
        Number value = (Number)this.getMaxValue();
        return value != null ? value.doubleValue() : Double.POSITIVE_INFINITY;
    }

    public double getMaxDouble(boolean inclusive) {
        double value = this.getMaxDouble();
        if (inclusive != this.isMaxIncluded()) {
            value = NumberRange.next(this.getElementType(), value, !inclusive);
        }
        return value;
    }

    private static double next(Class<?> type, double value, boolean up) {
        if (!up) {
            value = -value;
        }
        if (Numbers.isInteger(type)) {
            value += 1.0;
        } else if (type.equals(Float.class)) {
            value = Math.nextUp((float)value);
        } else if (type.equals(Double.class)) {
            value = Math.nextUp(value);
        } else {
            throw new IllegalStateException(Errors.format((short)90, type));
        }
        if (!up) {
            value = -value;
        }
        return value;
    }

    public boolean containsAny(Number value) throws IllegalArgumentException {
        int c;
        if (value == null) {
            return false;
        }
        Class<? extends Number> type = Numbers.widestClass(this.elementType, value.getClass());
        value = Numbers.cast(value, type);
        if (this.minValue != null) {
            c = ((Comparable)((Object)Numbers.cast((Number)((Object)this.minValue), type))).compareTo(value);
            if (this.isMinIncluded ? c > 0 : c >= 0) {
                return false;
            }
        }
        if (this.maxValue != null) {
            c = ((Comparable)((Object)Numbers.cast((Number)((Object)this.maxValue), type))).compareTo(value);
            if (this.isMaxIncluded ? c < 0 : c <= 0) {
                return false;
            }
        }
        return true;
    }

    public boolean containsAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        return this.castTo(type).contains(this.convertAndCast(range, type));
    }

    public boolean intersectsAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        return this.castTo(type).intersects(this.convertAndCast(range, type));
    }

    public NumberRange<?> intersectAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        NumberRange<? extends Number> intersect = NumberRange.castOrCopy(this.castTo(type).intersect(this.convertAndCast(range, type)));
        type = Numbers.narrowestClass(this.elementType, range.elementType);
        type = Numbers.widestClass(type, Numbers.narrowestClass((Number)((Object)intersect.minValue)));
        type = Numbers.widestClass(type, Numbers.narrowestClass((Number)((Object)intersect.maxValue)));
        return intersect.castTo(type);
    }

    public NumberRange<?> unionAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        return NumberRange.castOrCopy(this.castTo(type).union(this.convertAndCast(range, type)));
    }

    public NumberRange<?>[] subtractAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        return (NumberRange[])this.castTo(type).subtract(this.convertAndCast(range, type));
    }
}

