/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.util.PatchedUnitFormat;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;

class SexagesimalConverter
extends UnitConverter {
    private static final long serialVersionUID = -2119974989555436361L;
    static final double EPS = 1.0E-10;
    static final Unit<Angle> DM = NonSI.DEGREE_ANGLE.transform(new SexagesimalConverter(false, 100.0).inverse()).asType(Angle.class);
    static final Unit<Angle> DMS = NonSI.DEGREE_ANGLE.transform(new SexagesimalConverter(true, 10000.0).inverse()).asType(Angle.class);
    static final Unit<Angle> DMS_SCALED = NonSI.DEGREE_ANGLE.transform(new SexagesimalConverter(true, 1.0).inverse()).asType(Angle.class);
    final boolean hasSeconds;
    final double divider;
    private final UnitConverter inverse;

    private SexagesimalConverter(boolean hasSeconds, double divider) {
        this.hasSeconds = hasSeconds;
        this.divider = divider;
        this.inverse = new Inverse(this);
    }

    private SexagesimalConverter(SexagesimalConverter inverse) {
        this.hasSeconds = inverse.hasSeconds;
        this.divider = inverse.divider;
        this.inverse = inverse;
    }

    @Override
    public final UnitConverter inverse() {
        return this.inverse;
    }

    @Override
    public double convert(double angle) {
        double deg = MathFunctions.truncate(angle);
        angle = (angle - deg) * 60.0;
        if (this.hasSeconds) {
            double min = MathFunctions.truncate(angle);
            angle = (angle - min) * 60.0;
            angle += (deg * 100.0 + min) * 100.0;
        } else {
            angle += deg * 100.0;
        }
        return angle / this.divider;
    }

    @Override
    public final BigDecimal convert(BigDecimal value, MathContext context) {
        return new BigDecimal(this.convert(value.doubleValue()), context);
    }

    @Override
    public final boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && ((SexagesimalConverter)object).divider == this.divider;
    }

    @Override
    public final int hashCode() {
        return (int)this.divider ^ this.getClass().hashCode();
    }

    static {
        PatchedUnitFormat.init(DM, "D.M", DMS, "D.MS", DMS_SCALED, "DMS");
    }

    private static final class Inverse
    extends SexagesimalConverter {
        private static final long serialVersionUID = -1928146841653975281L;

        public Inverse(SexagesimalConverter inverse) {
            super(inverse);
        }

        @Override
        public double convert(double angle) throws IllegalArgumentException {
            double min;
            double deg;
            double sec;
            if (this.hasSeconds) {
                sec = angle * this.divider;
                deg = MathFunctions.truncate(sec / 10000.0);
                min = MathFunctions.truncate((sec -= 10000.0 * deg) / 100.0);
                sec -= 100.0 * min;
            } else {
                sec = 0.0;
                min = angle * this.divider;
                deg = MathFunctions.truncate(min / 100.0);
                min -= deg * 100.0;
            }
            if (min <= -60.0 || min >= 60.0) {
                if (Math.abs(Math.abs(min) - 100.0) <= 1.0E-8) {
                    deg = min >= 0.0 ? (deg += 1.0) : (deg -= 1.0);
                    min = 0.0;
                } else {
                    throw Inverse.illegalField(angle, min, (short)2);
                }
            }
            if (sec <= -60.0 || sec >= 60.0) {
                if (Math.abs(Math.abs(sec) - 100.0) <= 1.0E-8) {
                    min = sec >= 0.0 ? (min += 1.0) : (min -= 1.0);
                    sec = 0.0;
                } else {
                    throw Inverse.illegalField(angle, sec, (short)3);
                }
            }
            return (sec / 60.0 + min) / 60.0 + deg;
        }

        private static IllegalArgumentException illegalField(double value, double field, short unit) {
            return new IllegalArgumentException(Errors.format((short)30, "angle", value, Vocabulary.format(unit), field));
        }
    }
}

