/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Length;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.util.DefinitionURI;
import org.apache.sis.internal.util.XPaths;
import org.apache.sis.measure.SexagesimalConverter;
import org.apache.sis.measure.UnitsMap;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class Units
extends Static {
    private static final String[] CARDINAL_DIRECTIONS = new String[]{"east", "west", "north", "south"};
    public static final Unit<Duration> MILLISECOND = SI.MetricPrefix.MILLI(SI.SECOND);
    private static final Unit<Duration> YEAR = SI.SECOND.divide(3.1556925445E7);
    public static final Unit<Dimensionless> PPM = Unit.ONE.times(1.0E-6);
    static final Unit<Dimensionless> PSU = Unit.ONE.alternate("psu");
    static final Unit<Dimensionless> SIGMA = Unit.ONE.alternate("sigma");

    private Units() {
    }

    public static boolean isAngular(Unit<?> unit) {
        return unit != null && unit.toSI().equals(SI.RADIAN);
    }

    public static boolean isLinear(Unit<?> unit) {
        return unit != null && unit.toSI().equals(SI.METRE);
    }

    public static boolean isPressure(Unit<?> unit) {
        return unit != null && unit.toSI().equals(SI.PASCAL);
    }

    public static boolean isTemporal(Unit<?> unit) {
        return unit != null && unit.toSI().equals(SI.SECOND);
    }

    public static boolean isScale(Unit<?> unit) {
        return unit != null && unit.toSI().equals(Unit.ONE);
    }

    public static Unit<Angle> ensureAngular(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isAngular(unit)) {
            throw new IllegalArgumentException(Errors.format((short)78, unit));
        }
        return unit;
    }

    public static Unit<Length> ensureLinear(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isLinear(unit)) {
            throw new IllegalArgumentException(Errors.format((short)84, unit));
        }
        return unit;
    }

    public static Unit<Duration> ensureTemporal(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isTemporal(unit)) {
            throw new IllegalArgumentException(Errors.format((short)87, unit));
        }
        return unit;
    }

    public static Unit<Dimensionless> ensureScale(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isScale(unit)) {
            throw new IllegalArgumentException(Errors.format((short)86, unit));
        }
        return unit;
    }

    public static <Q extends Quantity> Unit<Q> multiply(Unit<Q> unit, double factor) {
        if (SI.RADIAN.equals(unit)) {
            if (Math.abs(factor - Math.PI / 180) <= 1.7453292519943296E-12) {
                return NonSI.DEGREE_ANGLE;
            }
            if (Math.abs(factor - 0.015707963267948967) <= 1.5707963267948967E-12) {
                return NonSI.GRADE;
            }
        } else if (SI.METRE.equals(unit)) {
            if (Math.abs(factor - 0.3048) <= 3.048E-11) {
                return NonSI.FOOT;
            }
            if (Math.abs(factor - 0.3048006096012192) <= 3.048006096012192E-11) {
                return NonSI.FOOT_SURVEY_US;
            }
        }
        if (Math.abs(factor - 1.0) > 1.0E-10) {
            long fl = (long)factor;
            unit = (double)fl == factor ? unit.times(fl) : unit.times(factor);
        }
        return UnitsMap.canonicalize(unit);
    }

    public static <Q extends Quantity> double toStandardUnit(Unit<Q> unit) {
        return Units.derivative(unit.getConverterTo(unit.toSI()), 0.0);
    }

    public static double derivative(UnitConverter converter, double value) {
        return converter.convert(value + 1.0) - converter.convert(value);
    }

    public static Unit<?> valueOf(String uom) throws IllegalArgumentException {
        Unit<Frequency> unit;
        if (uom == null) {
            return null;
        }
        uom = CharSequences.trimWhitespaces(CharSequences.toASCII(uom)).toString();
        int length = uom.length();
        if (Units.isURI(uom)) {
            String code = DefinitionURI.codeOf("uom", "EPSG", uom);
            if (code != null && code != uom) {
                try {
                    return Units.valueOfEPSG(Integer.parseInt(code));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(Errors.format((short)31, "uom", uom), e);
                }
            }
            code = XPaths.xpointer("uom", uom);
            if (code != null) {
                uom = code;
            }
        }
        if (uom.regionMatches(true, 0, "deg", 0, 3)) {
            String suffix;
            switch (length) {
                case 3: {
                    return NonSI.DEGREE_ANGLE;
                }
                case 4: {
                    if (uom.charAt(3) != 'K') break;
                    return SI.KELVIN;
                }
            }
            String prefix = uom;
            boolean isTemperature = false;
            int s = Math.max(uom.lastIndexOf(32), uom.lastIndexOf(95));
            if (s >= 1 && (ArraysExt.containsIgnoreCase(CARDINAL_DIRECTIONS, suffix = (String)CharSequences.trimWhitespaces(uom, s + 1, length)) || (isTemperature = Units.isCelsius(suffix)))) {
                prefix = (String)CharSequences.trimWhitespaces(uom, 0, s);
            }
            if (Units.equalsIgnorePlural(prefix, "degree")) {
                return isTemperature ? SI.CELSIUS : NonSI.DEGREE_ANGLE;
            }
        } else {
            if (uom.equals("\u00b0") || Units.equalsIgnorePlural(uom, "decimal_degree")) {
                return NonSI.DEGREE_ANGLE;
            }
            if (uom.equalsIgnoreCase("arcsec")) {
                return NonSI.SECOND_ANGLE;
            }
            if (uom.equalsIgnoreCase("rad") || Units.equalsIgnorePlural(uom, "radian")) {
                return SI.RADIAN;
            }
            if (Units.equalsIgnorePlural(uom, "meter") || Units.equalsIgnorePlural(uom, "metre")) {
                return SI.METRE;
            }
            if (Units.equalsIgnorePlural(uom, "kilometer") || Units.equalsIgnorePlural(uom, "kilometre")) {
                return SI.KILOMETRE;
            }
            if (Units.equalsIgnorePlural(uom, "week")) {
                return NonSI.WEEK;
            }
            if (Units.equalsIgnorePlural(uom, "day")) {
                return NonSI.DAY;
            }
            if (Units.equalsIgnorePlural(uom, "hour")) {
                return NonSI.HOUR;
            }
            if (Units.equalsIgnorePlural(uom, "minute")) {
                return NonSI.MINUTE;
            }
            if (Units.equalsIgnorePlural(uom, "second")) {
                return SI.SECOND;
            }
            if (Units.equalsIgnorePlural(uom, "pixel")) {
                return NonSI.PIXEL;
            }
            if (Units.equalsIgnorePlural(uom, "grade")) {
                return NonSI.GRADE;
            }
            if (Units.isCelsius(uom)) {
                return SI.CELSIUS;
            }
            if (uom.isEmpty()) {
                return Unit.ONE;
            }
            if (uom.equalsIgnoreCase("US survey foot")) {
                return NonSI.FOOT_SURVEY_US;
            }
            if (uom.equalsIgnoreCase("ppm")) {
                return PPM;
            }
            if (uom.equalsIgnoreCase("psu")) {
                return PSU;
            }
            if (uom.equalsIgnoreCase("sigma")) {
                return SIGMA;
            }
        }
        try {
            unit = Unit.valueOf(uom);
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.setMessage(e, Errors.format((short)31, "uom", uom), true);
        }
        if (unit.isCompatible(SI.HERTZ) && !uom.equals("Bd")) {
            return SI.HERTZ;
        }
        return UnitsMap.canonicalize(unit);
    }

    private static boolean equalsIgnorePlural(String uom, String expected) {
        int length = expected.length();
        switch (uom.length() - length) {
            case 0: {
                break;
            }
            case 1: {
                if (Character.toLowerCase(uom.charAt(length)) == 's') break;
            }
            default: {
                return false;
            }
        }
        return uom.regionMatches(true, 0, expected, 0, length);
    }

    private static boolean isCelsius(String uom) {
        return uom.equalsIgnoreCase("Celsius") || uom.equalsIgnoreCase("Celcius");
    }

    private static boolean isURI(String uom) {
        int i = uom.length();
        while (--i >= 0) {
            char c = uom.charAt(i);
            if (c != ':' && c != '#') continue;
            return true;
        }
        return false;
    }

    public static Unit<?> valueOfEPSG(int code) {
        switch (code) {
            case 9102: 
            case 9122: {
                return NonSI.DEGREE_ANGLE;
            }
            case 9001: {
                return SI.METRE;
            }
            case 1029: {
                return YEAR;
            }
            case 1040: {
                return SI.SECOND;
            }
            case 9002: {
                return NonSI.FOOT;
            }
            case 9003: {
                return NonSI.FOOT_SURVEY_US;
            }
            case 9030: {
                return NonSI.NAUTICAL_MILE;
            }
            case 9036: {
                return SI.KILOMETRE;
            }
            case 9101: {
                return SI.RADIAN;
            }
            case 9103: {
                return NonSI.MINUTE_ANGLE;
            }
            case 9104: {
                return NonSI.SECOND_ANGLE;
            }
            case 9105: {
                return NonSI.GRADE;
            }
            case 9109: {
                return SI.MetricPrefix.MICRO(SI.RADIAN);
            }
            case 9107: 
            case 9108: {
                return SexagesimalConverter.DMS_SCALED;
            }
            case 9110: {
                return SexagesimalConverter.DMS;
            }
            case 9111: {
                return SexagesimalConverter.DM;
            }
            case 9201: 
            case 9203: {
                return Unit.ONE;
            }
            case 9202: {
                return PPM;
            }
        }
        return null;
    }

    public static Integer getEpsgCode(Unit<?> unit, boolean inAxis) {
        Integer code = UnitsMap.EPSG_CODES.get(unit);
        if (inAxis && code != null && code == 9102) {
            code = UnitsMap.EPSG_AXIS_DEGREES;
        }
        return code;
    }
}

