/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.Static;

final class UnitsMap
extends Static {
    static final Integer EPSG_AXIS_DEGREES;
    static final Map<Unit<?>, Integer> EPSG_CODES;
    private static final Map<Unit<?>, Unit<?>> COMMONS;

    private UnitsMap() {
    }

    static <A extends Quantity> Unit<A> canonicalize(Unit<A> unit) {
        Unit<?> candidate = COMMONS.get(unit);
        if (candidate != null) {
            return candidate;
        }
        return unit;
    }

    static {
        byte[] codes;
        EPSG_AXIS_DEGREES = 9122;
        EPSG_CODES = new HashMap(20);
        for (byte c : codes = new byte[]{1, 2, 30, 36, 101, 102, 103, 104, 105, 108, 109, 111, 110, -55, -54}) {
            int code = 9000 + (c & 0xFF);
            EPSG_CODES.put(Units.valueOfEPSG(code), code);
        }
        COMMONS = new HashMap(48);
        COMMONS.put(Units.MILLISECOND, Units.MILLISECOND);
        boolean nonSI = false;
        do {
            for (Field field : (nonSI ? NonSI.class : SI.class).getFields()) {
                Unit unit;
                Object value;
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                try {
                    value = field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                if (!(value instanceof Unit) || !Units.isLinear(unit = (Unit)value) && !Units.isAngular(unit) && !Units.isScale(unit)) continue;
                COMMONS.put(unit, unit);
            }
        } while (nonSI = !nonSI);
    }
}

