/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.identification.DefaultRepresentativeFraction;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.collection.Containers;

final class Cloner
extends org.apache.sis.internal.util.Cloner {
    Cloner() {
    }

    @Override
    protected boolean isCloneRequired(Object object) {
        return false;
    }

    private void clones(Object[] array) throws CloneNotSupportedException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.clone(array[i]);
        }
    }

    @Override
    public Object clone(Object object) throws CloneNotSupportedException {
        if (object instanceof ModifiableMetadata) {
            return ((ModifiableMetadata)object).unmodifiable();
        }
        if (object instanceof DefaultRepresentativeFraction) {
            DefaultRepresentativeFraction c = ((DefaultRepresentativeFraction)object).clone();
            c.freeze();
            return c;
        }
        if (object instanceof Collection) {
            Collection<Object> collection = (List<Object>)object;
            boolean isSet = collection instanceof Set;
            Object[] objectArray = collection.toArray();
            switch (objectArray.length) {
                case 0: {
                    collection = isSet ? Collections.EMPTY_SET : Collections.EMPTY_LIST;
                    break;
                }
                case 1: {
                    Object value = this.clone(objectArray[0]);
                    collection = isSet ? Collections.singleton(value) : Collections.singletonList(value);
                    break;
                }
                default: {
                    if (isSet) {
                        if (collection instanceof EnumSet) {
                            collection = Collections.unmodifiableSet(((EnumSet)collection).clone());
                            break;
                        }
                        if (collection instanceof CodeListSet) {
                            collection = Collections.unmodifiableSet(((CodeListSet)collection).clone());
                            break;
                        }
                        this.clones(objectArray);
                        collection = CollectionsExt.immutableSet(false, objectArray);
                        break;
                    }
                    this.clones(objectArray);
                    collection = Containers.unmodifiableList(objectArray);
                }
            }
            return collection;
        }
        if (object instanceof Map) {
            LinkedHashMap map = new LinkedHashMap((Map)object);
            for (Map.Entry entry : map.entrySet()) {
                entry.setValue(this.clone(entry.getValue()));
            }
            return CollectionsExt.unmodifiableOrCopy(map);
        }
        if (object instanceof Cloneable) {
            return super.clone(object);
        }
        return object;
    }
}

