/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sis.internal.jdk8.BiFunction;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.metadata.InformationMap;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.NameMap;
import org.apache.sis.metadata.ObjectPair;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.RecursivityGuard;
import org.apache.sis.metadata.SpecialCases;
import org.apache.sis.metadata.StandardImplementation;
import org.apache.sis.metadata.TreeTableView;
import org.apache.sis.metadata.TypeMap;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.ValueMap;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.citation.Citation;

public class MetadataStandard
implements Serializable {
    private static final long serialVersionUID = 7549790450195184843L;
    static final boolean IMPLEMENTATION_CAN_ALTER_API = true;
    private static final MetadataStandard[] INSTANCES;
    public static final MetadataStandard ISO_19111;
    public static final MetadataStandard ISO_19115;
    public static final MetadataStandard ISO_19123;
    final Citation citation;
    final String interfacePackage;
    private final MetadataStandard[] dependencies;
    private final transient ConcurrentMap<Class<?>, Object> accessors;

    public MetadataStandard(Citation citation, Package interfacePackage, MetadataStandard ... dependencies) {
        ArgumentChecks.ensureNonNull("citation", citation);
        ArgumentChecks.ensureNonNull("interfacePackage", interfacePackage);
        ArgumentChecks.ensureNonNull("dependencies", dependencies);
        this.citation = citation;
        this.interfacePackage = interfacePackage.getName() + '.';
        this.accessors = new ConcurrentHashMap();
        if (dependencies.length == 0) {
            this.dependencies = null;
        } else {
            dependencies = (MetadataStandard[])dependencies.clone();
            this.dependencies = dependencies;
            for (int i = 0; i < dependencies.length; ++i) {
                ArgumentChecks.ensureNonNullElement("dependencies", i, dependencies[i]);
            }
        }
    }

    MetadataStandard(String citation, String interfacePackage, MetadataStandard[] dependencies) {
        this.citation = new SimpleCitation(citation);
        this.interfacePackage = interfacePackage;
        this.accessors = new ConcurrentHashMap();
        this.dependencies = dependencies;
    }

    final boolean isSupported(String classname) {
        return classname.startsWith(this.interfacePackage);
    }

    public static MetadataStandard forClass(Class<?> type) {
        String classname = type.getName();
        for (MetadataStandard metadataStandard : INSTANCES) {
            if (!metadataStandard.isSupported(classname)) continue;
            return metadataStandard;
        }
        for (Serializable serializable : Classes.getAllInterfaces(type)) {
            classname = ((Class)serializable).getName();
            for (MetadataStandard candidate : INSTANCES) {
                if (!candidate.isSupported(classname)) continue;
                return candidate;
            }
        }
        return null;
    }

    static void clearCache() {
        for (MetadataStandard standard : INSTANCES) {
            standard.accessors.clear();
        }
    }

    public Citation getCitation() {
        return this.citation;
    }

    final PropertyAccessor getAccessor(final Class<?> implementation, boolean mandatory) {
        Class<?> type;
        Object value = this.accessors.get(implementation);
        if (value instanceof PropertyAccessor) {
            return (PropertyAccessor)value;
        }
        if (value instanceof Class) {
            type = (Class<?>)value;
            assert (type == this.findInterface(implementation)) : implementation;
        } else {
            type = this.findInterface(implementation);
            if (type == null) {
                if (this.dependencies != null) {
                    for (MetadataStandard dependency : this.dependencies) {
                        PropertyAccessor accessor = dependency.getAccessor(implementation, false);
                        if (accessor == null) continue;
                        this.accessors.put(implementation, accessor);
                        return accessor;
                    }
                }
                if (mandatory) {
                    throw new ClassCastException(Errors.format((short)118, implementation));
                }
                return null;
            }
        }
        return (PropertyAccessor)JDK8.compute(this.accessors, implementation, new BiFunction<Class<?>, Object, Object>(){

            @Override
            public Object apply(Class<?> k, Object v) {
                if (v instanceof PropertyAccessor) {
                    return v;
                }
                PropertyAccessor accessor = SpecialCases.isSpecialCase(type) ? new SpecialCases(MetadataStandard.this.citation, type, implementation) : new PropertyAccessor(MetadataStandard.this.citation, type, implementation);
                return accessor;
            }
        });
    }

    public boolean isMetadata(Class<?> type) {
        if (type != null) {
            Class<?> standardType;
            if (this.accessors.containsKey(type)) {
                return true;
            }
            if (this.dependencies != null) {
                for (MetadataStandard dependency : this.dependencies) {
                    if (!dependency.isMetadata(type)) continue;
                    this.accessors.putIfAbsent(type, dependency);
                    return true;
                }
            }
            if ((standardType = this.findInterface(type)) != null) {
                this.accessors.putIfAbsent(type, standardType);
                return true;
            }
        }
        return false;
    }

    boolean isPendingAPI(Class<?> type) {
        return false;
    }

    private Class<?> findInterface(Class<?> type) {
        if (type != null) {
            if (type.isInterface()) {
                if (this.isSupported(type.getName())) {
                    return type;
                }
            } else {
                Class candidate;
                LinkedHashSet interfaces = new LinkedHashSet();
                for (Class<?> t = type; t != null; t = t.getSuperclass()) {
                    this.getInterfaces(t, interfaces);
                }
                Iterator it = interfaces.iterator();
                block1: while (it.hasNext()) {
                    candidate = (Class)it.next();
                    for (Class clazz : interfaces) {
                        if (candidate == clazz || !candidate.isAssignableFrom(clazz)) continue;
                        it.remove();
                        continue block1;
                    }
                }
                it = interfaces.iterator();
                if (it.hasNext()) {
                    candidate = (Class)it.next();
                    if (!it.hasNext()) {
                        return candidate;
                    }
                } else if (this.isPendingAPI(type)) {
                    return type;
                }
            }
        }
        return null;
    }

    private void getInterfaces(Class<?> type, Collection<Class<?>> interfaces) {
        for (Class<?> candidate : type.getInterfaces()) {
            if (this.isSupported(candidate.getName())) {
                interfaces.add(candidate);
            }
            this.getInterfaces(candidate, interfaces);
        }
    }

    public <T> Class<? super T> getInterface(Class<T> type) throws ClassCastException {
        Class<T> interf;
        ArgumentChecks.ensureNonNull("type", type);
        Object value = this.accessors.get(type);
        if (value instanceof PropertyAccessor) {
            interf = ((PropertyAccessor)value).type;
        } else if (value instanceof Class) {
            interf = (Class<T>)value;
        } else if (value instanceof MetadataStandard) {
            interf = ((MetadataStandard)value).getInterface(type);
        } else {
            interf = this.findInterface(type);
            if (interf != null) {
                this.accessors.putIfAbsent(type, interf);
            } else {
                if (this.dependencies != null) {
                    for (MetadataStandard dependency : this.dependencies) {
                        if (!dependency.isMetadata(type)) continue;
                        this.accessors.putIfAbsent(type, dependency);
                        return dependency.getInterface(type);
                    }
                }
                throw new ClassCastException(Errors.format((short)118, type));
            }
        }
        assert (interf.isAssignableFrom(type)) : type;
        return interf;
    }

    public <T> Class<? extends T> getImplementation(Class<T> type) {
        return null;
    }

    public Map<String, String> asNameMap(Class<?> type, KeyNamePolicy keyPolicy, KeyNamePolicy valuePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("keyPolicy", (Object)keyPolicy);
        ArgumentChecks.ensureNonNull("valuePolicy", (Object)valuePolicy);
        Class<?> implementation = this.getImplementation(type);
        if (implementation != null) {
            type = implementation;
        }
        return new NameMap(this.getAccessor(type, true), keyPolicy, valuePolicy);
    }

    public Map<String, Class<?>> asTypeMap(Class<?> type, KeyNamePolicy keyPolicy, TypeValuePolicy valuePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("keyPolicy", (Object)keyPolicy);
        ArgumentChecks.ensureNonNull("valuePolicy", (Object)valuePolicy);
        Class<?> implementation = this.getImplementation(type);
        if (implementation != null) {
            type = implementation;
        }
        return new TypeMap(this.getAccessor(type, true), keyPolicy, valuePolicy);
    }

    public Map<String, ExtendedElementInformation> asInformationMap(Class<?> type, KeyNamePolicy keyPolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("keyNames", (Object)keyPolicy);
        Class<?> implementation = this.getImplementation(type);
        if (implementation != null) {
            type = implementation;
        }
        return new InformationMap(this.getAccessor(type, true), keyPolicy);
    }

    public Map<String, Object> asValueMap(Object metadata, KeyNamePolicy keyPolicy, ValueExistencePolicy valuePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("metadata", metadata);
        ArgumentChecks.ensureNonNull("keyPolicy", (Object)keyPolicy);
        ArgumentChecks.ensureNonNull("valuePolicy", (Object)valuePolicy);
        return new ValueMap(metadata, this.getAccessor(metadata.getClass(), true), keyPolicy, valuePolicy);
    }

    public TreeTable asTreeTable(Object metadata, ValueExistencePolicy valuePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull("metadata", metadata);
        ArgumentChecks.ensureNonNull("valuePolicy", (Object)valuePolicy);
        return new TreeTableView(this, metadata, valuePolicy);
    }

    final void freeze(Object metadata) throws ClassCastException {
        this.getAccessor(metadata.getClass(), true).freeze(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object metadata1, Object metadata2, ComparisonMode mode) throws ClassCastException {
        Class<?> type2;
        if (metadata1 == metadata2) {
            return true;
        }
        if (metadata1 == null || metadata2 == null) {
            return false;
        }
        Class<?> type1 = metadata1.getClass();
        if (type1 != (type2 = metadata2.getClass()) && mode == ComparisonMode.STRICT) {
            return false;
        }
        PropertyAccessor accessor = this.getAccessor(type1, true);
        if (!(type1 == type2 || accessor.type.isAssignableFrom(type2) && accessor.type == this.getAccessor(type2, (boolean)false).type)) {
            return false;
        }
        ObjectPair pair = new ObjectPair(metadata1, metadata2);
        Set<ObjectPair> inProgress = ObjectPair.CURRENT.get();
        if (inProgress.add(pair)) {
            boolean allowNull = Semaphores.queryAndSet((byte)4);
            try {
                boolean bl = accessor.equals(metadata1, metadata2, mode);
                return bl;
            }
            finally {
                inProgress.remove(pair);
                if (!allowNull) {
                    Semaphores.clear((byte)4);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode(Object metadata) throws ClassCastException {
        Map inProgress;
        if (metadata != null && (inProgress = (Map)RecursivityGuard.HASH_CODES.get()).put(metadata, Boolean.TRUE) == null) {
            boolean allowNull = Semaphores.queryAndSet((byte)4);
            try {
                int n = this.getAccessor(metadata.getClass(), true).hashCode(metadata);
                return n;
            }
            finally {
                inProgress.remove(metadata);
                if (!allowNull) {
                    Semaphores.clear((byte)4);
                }
            }
        }
        return 0;
    }

    public String toString() {
        return Classes.getShortClassName(this) + '[' + this.citation.getTitle() + ']';
    }

    final void setMapForField(Class<?> classe, String name) {
        try {
            Field field = classe.getDeclaredField(name);
            field.setAccessible(true);
            field.set(this, new ConcurrentHashMap());
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setMapForField(MetadataStandard.class, "accessors");
    }

    static {
        String[] prefix = new String[]{"Default", "Abstract"};
        String[] acronyms = new String[]{"CoordinateSystem", "CS", "CoordinateReferenceSystem", "CRS"};
        ISO_19115 = new StandardImplementation("ISO 19115", "org.opengis.metadata.", "org.apache.sis.metadata.iso.", prefix, null, null);
        ISO_19111 = new StandardImplementation("ISO 19111", "org.opengis.referencing.", "org.apache.sis.referencing.", prefix, acronyms, new MetadataStandard[]{ISO_19115});
        ISO_19123 = new MetadataStandard("ISO 19123", "org.opengis.coverage.", new MetadataStandard[]{ISO_19111});
        INSTANCES = new MetadataStandard[]{ISO_19111, ISO_19115, ISO_19123};
        SystemListener.add(new SystemListener("org.apache.sis.metadata"){

            @Override
            protected void classpathChanged() {
                MetadataStandard.clearCache();
            }
        });
    }
}

