/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.internal.util.CheckedHashSet;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.UnmodifiableMetadataException;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.CodeList;

@XmlTransient
public abstract class ModifiableMetadata
extends AbstractMetadata
implements Cloneable {
    private static final int INITIAL_CAPACITY = 4;
    private static final ModifiableMetadata FREEZING = new Null();
    private transient ModifiableMetadata unmodifiable;

    protected ModifiableMetadata() {
    }

    public final boolean isModifiable() {
        return this.unmodifiable != this && this.unmodifiable != FREEZING;
    }

    public AbstractMetadata unmodifiable() {
        if (this.unmodifiable == null) {
            ModifiableMetadata candidate;
            try {
                candidate = this.clone();
            }
            catch (CloneNotSupportedException exception) {
                Logging.unexpectedException(Logging.getLogger("org.apache.sis.metadata"), this.getClass(), "unmodifiable", exception);
                return this;
            }
            candidate.freeze();
            this.unmodifiable = candidate;
        }
        assert (!this.unmodifiable.isModifiable());
        return this.unmodifiable;
    }

    public void freeze() {
        if (this.isModifiable()) {
            ModifiableMetadata success = null;
            boolean allowNull = Semaphores.queryAndSet((byte)4);
            try {
                this.unmodifiable = FREEZING;
                this.getStandard().freeze(this);
                success = this;
            }
            finally {
                this.unmodifiable = success;
                if (!allowNull) {
                    Semaphores.clear((byte)4);
                }
            }
        }
    }

    protected void checkWritePermission() throws UnmodifiableMetadataException {
        if (this.unmodifiable != null) {
            if (this.unmodifiable == this) {
                throw new UnmodifiableMetadataException(Errors.format((short)122));
            }
            if (this.unmodifiable != FREEZING) {
                this.unmodifiable = null;
            }
        }
    }

    protected final <E> List<E> writeList(Collection<? extends E> source, List<E> target, Class<E> elementType) throws UnmodifiableMetadataException {
        if (source != target) {
            if (this.unmodifiable == FREEZING) {
                return (List)source;
            }
            this.checkWritePermission();
            if (Containers.isNullOrEmpty(source)) {
                target = null;
            } else {
                if (target != null) {
                    target.clear();
                } else {
                    target = new CheckedArrayList<E>(elementType, source.size());
                }
                target.addAll(source);
            }
        }
        return target;
    }

    protected final <E> Set<E> writeSet(Collection<? extends E> source, Set<E> target, Class<E> elementType) throws UnmodifiableMetadataException {
        if (source != target) {
            if (this.unmodifiable == FREEZING) {
                return (Set)source;
            }
            this.checkWritePermission();
            if (Containers.isNullOrEmpty(source)) {
                target = null;
            } else {
                if (target != null) {
                    target.clear();
                } else {
                    target = new CheckedHashSet<E>(elementType, source.size());
                }
                target.addAll(source);
            }
        }
        return target;
    }

    protected final <E> Collection<E> writeCollection(Collection<? extends E> source, Collection<E> target, Class<E> elementType) throws UnmodifiableMetadataException {
        if (source != target) {
            if (this.unmodifiable == FREEZING) {
                assert (this.collectionType(elementType).isInstance(source));
                return source;
            }
            this.checkWritePermission();
            if (Containers.isNullOrEmpty(source)) {
                target = null;
            } else {
                if (target != null) {
                    target.clear();
                } else {
                    int capacity = source.size();
                    target = this.useSet(elementType) ? this.createSet(elementType, capacity) : new CheckedArrayList<E>(elementType, capacity);
                }
                target.addAll(source);
            }
        }
        return target;
    }

    protected final <E> List<E> copyList(Collection<? extends E> source, Class<E> elementType) {
        if (Containers.isNullOrEmpty(source)) {
            return null;
        }
        CheckedArrayList<E> target = new CheckedArrayList<E>(elementType, source.size());
        target.addAll(source);
        return target;
    }

    protected final <E> Set<E> copySet(Collection<? extends E> source, Class<E> elementType) {
        if (Containers.isNullOrEmpty(source)) {
            return null;
        }
        CheckedHashSet<E> target = new CheckedHashSet<E>(elementType, source.size());
        target.addAll(source);
        return target;
    }

    protected final <E> Collection<E> copyCollection(Collection<? extends E> source, Class<E> elementType) {
        if (Containers.isNullOrEmpty(source)) {
            return null;
        }
        int capacity = source.size();
        Collection<E> target = this.useSet(elementType) ? this.createSet(elementType, capacity) : new CheckedArrayList<E>(elementType, capacity);
        target.addAll(source);
        return target;
    }

    protected final <E> Collection<E> singleton(E value, Class<E> elementType) {
        if (value == null) {
            return null;
        }
        Collection<E> collection = this.useSet(elementType) ? this.createSet(elementType, 4) : new CheckedArrayList<E>(elementType, 1);
        collection.add(value);
        return collection;
    }

    private static boolean emptyCollectionAsNull() {
        return Semaphores.query((byte)4);
    }

    protected final <E> List<E> nonNullList(List<E> c, Class<E> elementType) {
        if (c != null) {
            return c.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : c;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        if (this.isModifiable()) {
            return new CheckedArrayList<E>(elementType);
        }
        return Collections.emptyList();
    }

    protected final <E> Set<E> nonNullSet(Set<E> c, Class<E> elementType) {
        if (c != null) {
            return c.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : c;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        if (this.isModifiable()) {
            return this.createSet(elementType, 4);
        }
        return Collections.emptySet();
    }

    protected final <E> Collection<E> nonNullCollection(Collection<E> c, Class<E> elementType) {
        if (c != null) {
            assert (this.collectionType(elementType).isInstance(c));
            return c.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : c;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        boolean isModifiable = this.isModifiable();
        if (this.useSet(elementType)) {
            if (isModifiable) {
                return this.createSet(elementType, 4);
            }
            return Collections.emptySet();
        }
        if (isModifiable) {
            return new CheckedArrayList<E>(elementType);
        }
        return Collections.emptyList();
    }

    private <E> Set<E> createSet(Class<E> elementType, int capacity) {
        if (Enum.class.isAssignableFrom(elementType)) {
            return EnumSet.noneOf(elementType);
        }
        if (CodeList.class.isAssignableFrom(elementType) && Modifier.isFinal(elementType.getModifiers())) {
            return new CodeListSet<E>(elementType);
        }
        return new CheckedHashSet<E>(elementType, capacity);
    }

    private <E> boolean useSet(Class<E> elementType) {
        Class<Collection<E>> type = this.collectionType(elementType);
        if (Set.class == type) {
            return true;
        }
        if (List.class == type) {
            return false;
        }
        throw new NoSuchElementException(Errors.format((short)129, type));
    }

    protected <E> Class<? extends Collection<E>> collectionType(Class<E> elementType) {
        return CodeList.class.isAssignableFrom(elementType) || Enum.class.isAssignableFrom(elementType) || Charset.class.isAssignableFrom(elementType) || String.class == elementType || Locale.class == elementType || Currency.class == elementType ? Set.class : List.class;
    }

    protected ModifiableMetadata clone() throws CloneNotSupportedException {
        return (ModifiableMetadata)super.clone();
    }

    private static final class Null
    extends ModifiableMetadata {
        private Null() {
        }

        @Override
        public MetadataStandard getStandard() {
            return null;
        }
    }
}

