/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.RecursivityGuard;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.ValueMap;
import org.apache.sis.util.Emptiable;
import org.opengis.util.CodeList;

final class Pruner {
    private static final RecursivityGuard<Boolean> MAPS = new RecursivityGuard();

    private Pruner() {
    }

    private static Map<String, Object> asMap(MetadataStandard standard, Object metadata, boolean mandatory, boolean prune) {
        PropertyAccessor accessor = standard.getAccessor(metadata.getClass(), mandatory);
        if (accessor != null) {
            return new ValueMap(metadata, accessor, KeyNamePolicy.JAVABEANS_PROPERTY, prune ? ValueExistencePolicy.NON_NULL : ValueExistencePolicy.NON_EMPTY);
        }
        return null;
    }

    private static boolean isPrimitive(Map.Entry<String, Object> entry) {
        return entry instanceof ValueMap.Property && ((ValueMap.Property)entry).getValueType().isPrimitive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isEmpty(AbstractMetadata metadata, boolean mandatory, boolean prune) {
        Map<String, Object> properties = Pruner.asMap(metadata.getStandard(), metadata, mandatory, prune);
        if (properties == null) {
            return false;
        }
        Map tested = (Map)MAPS.get();
        if (!tested.isEmpty()) {
            return Pruner.isEmpty(properties, tested, prune);
        }
        try {
            tested.put(metadata, Boolean.FALSE);
            boolean bl = Pruner.isEmpty(properties, tested, prune);
            return bl;
        }
        finally {
            MAPS.remove();
        }
    }

    private static boolean isEmpty(Map<String, Object> properties, Map<Object, Boolean> tested, boolean prune) {
        boolean isEmpty = true;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object value = entry.getValue();
            Boolean isEntryEmpty = tested.put(value, Boolean.FALSE);
            if (isEntryEmpty != null) {
                if (isEntryEmpty.booleanValue()) {
                    tested.put(value, Boolean.TRUE);
                    continue;
                }
                isEmpty = false;
                if (prune) continue;
                break;
            }
            boolean allElementsAreEmpty = true;
            Collection<?> values = CollectionsExt.toCollection(value);
            Iterator<?> it = values.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                if (!ValueExistencePolicy.isNullOrEmpty(element)) {
                    boolean isEmptyElement = false;
                    if (element instanceof AbstractMetadata) {
                        AbstractMetadata md = (AbstractMetadata)element;
                        if (prune) {
                            md.prune();
                        }
                        isEmptyElement = md.isEmpty();
                    } else if (!prune && element instanceof Emptiable) {
                        isEmptyElement = ((Emptiable)element).isEmpty();
                    } else if (!(element instanceof Enum) && !(element instanceof CodeList)) {
                        MetadataStandard standard = MetadataStandard.forClass(element.getClass());
                        if (standard != null) {
                            isEmptyElement = Pruner.isEmpty(Pruner.asMap(standard, element, false, prune), tested, prune);
                            if (!isEmptyElement && element instanceof Emptiable) {
                                isEmptyElement = ((Emptiable)element).isEmpty();
                            }
                        } else if (Pruner.isPrimitive(entry)) {
                            isEmptyElement = value instanceof Number ? Double.isNaN(((Number)value).doubleValue()) : Boolean.FALSE.equals(value);
                        }
                    }
                    if (!isEmptyElement) {
                        if (!prune) {
                            return false;
                        }
                        allElementsAreEmpty = false;
                        continue;
                    }
                }
                if (!prune || values != value) continue;
                it.remove();
            }
            isEmpty &= allElementsAreEmpty;
            if (!allElementsAreEmpty) continue;
            tested.put(value, Boolean.TRUE);
            if (!prune) continue;
            try {
                entry.setValue(null);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return isEmpty;
    }
}

