/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.TreeNodeChildren;
import org.apache.sis.metadata.TreeTableView;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;

class TreeNode
implements TreeTable.Node {
    private static final Collection<TreeTable.Node> LEAF = Collections.emptySet();
    final TreeTableView table;
    private final TreeNode parent;
    final Object metadata;
    private transient CharSequence name;
    private transient Collection<TreeTable.Node> children;
    transient Object cachedValue;

    TreeNode(TreeTableView table, Object metadata) {
        this.table = table;
        this.parent = null;
        this.metadata = metadata;
    }

    TreeNode(TreeNode parent, Object metadata) {
        this.table = parent.table;
        this.parent = parent;
        this.metadata = metadata;
    }

    final void init() {
        if (!this.table.standard.isMetadata(this.getElementType())) {
            this.children = LEAF;
        }
    }

    String getIdentifier() {
        Class<?> type = this.table.standard.getInterface(this.metadata.getClass());
        String id = Types.getStandardName(type);
        return id != null ? id : Classes.getShortName(type);
    }

    Integer getIndex() {
        return null;
    }

    CharSequence getName() {
        return CharSequences.camelCaseToSentence(Classes.getShortName(this.table.standard.getInterface(this.metadata.getClass()))).toString();
    }

    void appendIdentifier(StringBuilder buffer) {
        buffer.append(Classes.getShortClassName(this.metadata));
    }

    public Class<?> getElementType() {
        return this.table.standard.getInterface(this.metadata.getClass());
    }

    @Override
    public Object getUserObject() {
        return this.metadata;
    }

    void setUserObject(Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.unmodifiableCellValue(TableColumn.VALUE));
    }

    boolean isWritable() {
        return false;
    }

    @Override
    public final TreeTable.Node getParent() {
        return this.parent;
    }

    @Override
    public final boolean isLeaf() {
        return this.children == LEAF;
    }

    @Override
    public final Collection<TreeTable.Node> getChildren() {
        if (!this.isLeaf()) {
            Object value = this.cachedValue;
            if (value == null && (value = this.getUserObject()) == null) {
                this.children = null;
                return LEAF;
            }
            this.cachedValue = null;
            if (this.children instanceof TreeNodeChildren) {
                TreeNodeChildren candidate = (TreeNodeChildren)this.children;
                if (candidate.metadata == value) {
                    return candidate;
                }
            }
            this.children = new TreeNodeChildren(this, value, this.table.standard.getAccessor(value.getClass(), true));
        }
        return this.children;
    }

    @Override
    public final TreeTable.Node newChild() throws UnsupportedOperationException {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException(Errors.format((short)76, this));
        }
        return new NewChild();
    }

    @Override
    public final <V> V getValue(TableColumn<V> column) {
        ArgumentChecks.ensureNonNull("column", column);
        Class<?> value = null;
        if (column == TableColumn.VALUE) {
            if (this.isLeaf()) {
                value = this.cachedValue;
                this.cachedValue = null;
                if (value == null) {
                    value = this.getUserObject();
                }
            }
        } else if (column == TableColumn.NAME) {
            if (this.name == null) {
                this.name = this.getName();
            }
            value = this.name;
        } else if (column == TableColumn.IDENTIFIER) {
            value = this.getIdentifier();
        } else if (column == TableColumn.INDEX) {
            value = this.getIndex();
        } else if (column == TableColumn.TYPE) {
            value = this.getElementType();
        }
        return column.getElementType().cast(value);
    }

    @Override
    public final <V> void setValue(TableColumn<V> column, V value) throws UnsupportedOperationException {
        ArgumentChecks.ensureNonNull("column", column);
        if (column != TableColumn.VALUE) {
            if (TreeTableView.COLUMNS.contains(column)) {
                throw new UnsupportedOperationException(this.unmodifiableCellValue(column));
            }
            throw new IllegalArgumentException(Errors.format((short)31, "column", column));
        }
        ArgumentChecks.ensureNonNull("value", value);
        this.cachedValue = null;
        this.setUserObject(value);
    }

    private String unmodifiableCellValue(TableColumn<?> column) {
        return Errors.format((short)120, this.getValue(TableColumn.NAME), column.getHeader());
    }

    @Override
    public final boolean isEditable(TableColumn<?> column) {
        ArgumentChecks.ensureNonNull("column", column);
        return column == TableColumn.VALUE && this.isWritable();
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder(60);
        this.toString(buffer);
        return buffer.toString();
    }

    final void toString(StringBuilder buffer) {
        this.appendIdentifier(buffer.append("Node["));
        buffer.append(" : ").append(Classes.getShortName(this.getElementType())).append(']');
    }

    private final class NewChild
    implements TreeTable.Node {
        private int indexInData = -1;
        private TreeNode delegate;

        private NewChild() {
        }

        private TreeNode delegate() throws IllegalStateException {
            if (this.delegate != null) {
                return this.delegate;
            }
            throw new IllegalStateException(Errors.format((short)65, (this.indexInData < 0 ? TableColumn.IDENTIFIER : TableColumn.VALUE).getHeader()));
        }

        private TreeNodeChildren getSiblings() {
            return (TreeNodeChildren)TreeNode.this.getChildren();
        }

        @Override
        public <V> void setValue(TableColumn<V> column, V value) {
            if (this.delegate == null) {
                if (column == TableColumn.IDENTIFIER) {
                    ArgumentChecks.ensureNonNull("value", value);
                    this.indexInData = this.getSiblings().accessor.indexOf((String)value, true);
                    return;
                }
                if (column == TableColumn.VALUE) {
                    ArgumentChecks.ensureNonNull("value", value);
                    if (this.indexInData < 0) {
                        throw new IllegalStateException(Errors.format((short)65, TableColumn.IDENTIFIER.getHeader()));
                    }
                    TreeNodeChildren siblings = this.getSiblings();
                    int indexInList = siblings.isCollection(this.indexInData) ? ((Collection)siblings.valueAt(this.indexInData)).size() : -1;
                    if (!siblings.add(this.indexInData, value)) {
                        throw new IllegalArgumentException(Errors.format((short)19, value));
                    }
                    this.delegate = siblings.childAt(this.indexInData, indexInList);
                    return;
                }
            }
            this.delegate().setValue(column, value);
        }

        @Override
        public TreeTable.Node getParent() {
            return TreeNode.this;
        }

        @Override
        public boolean isLeaf() {
            return this.delegate().isLeaf();
        }

        @Override
        public Collection<TreeTable.Node> getChildren() {
            return this.delegate().getChildren();
        }

        @Override
        public TreeTable.Node newChild() {
            return this.delegate().newChild();
        }

        @Override
        public <V> V getValue(TableColumn<V> column) {
            return this.delegate().getValue(column);
        }

        @Override
        public boolean isEditable(TableColumn<?> column) {
            return this.delegate().isEditable(column);
        }

        @Override
        public Object getUserObject() {
            return this.delegate().getUserObject();
        }
    }

    static final class CollectionElement
    extends Element {
        final int indexInList;

        CollectionElement(TreeNode parent, Object metadata, PropertyAccessor accessor, int indexInData, int indexInList) {
            super(parent, metadata, accessor, indexInData);
            this.indexInList = indexInList;
        }

        @Override
        void appendIdentifier(StringBuilder buffer) {
            super.appendIdentifier(buffer);
            buffer.append('[').append(this.indexInList).append(']');
        }

        @Override
        Integer getIndex() {
            return this.indexInList;
        }

        @Override
        CharSequence getName() {
            int size;
            CharSequence name = super.getName();
            Collection values = (Collection)super.getUserObject();
            if (values != null && (size = values.size()) >= 2) {
                name = Vocabulary.formatInternational((short)40, name, this.indexInList + 1, size);
            }
            return name;
        }

        @Override
        public Object getUserObject() {
            Collection values = (Collection)super.getUserObject();
            if (this.indexInList == 0 && this.table.valuePolicy.substituteByNullElement(values)) {
                return null;
            }
            try {
                if (values instanceof List) {
                    return ((List)values).get(this.indexInList);
                }
                Iterator it = values.iterator();
                for (int i = 0; i < this.indexInList; ++i) {
                    it.next();
                }
                return it.next();
            }
            catch (RuntimeException e) {
                throw (ConcurrentModificationException)new ConcurrentModificationException().initCause(e);
            }
        }

        @Override
        void setUserObject(Object value) {
            Collection values = (Collection)super.getUserObject();
            if (!(values instanceof List)) {
                throw new UnsupportedOperationException(Errors.format((short)128, "setValue"));
            }
            Class<Object> targetType = values instanceof CheckedContainer ? ((CheckedContainer)((Object)values)).getElementType() : this.getElementType();
            value = ObjectConverters.convert(value, targetType);
            try {
                ((List)values).set(this.indexInList, value);
            }
            catch (IndexOutOfBoundsException e) {
                throw (ConcurrentModificationException)new ConcurrentModificationException().initCause(e);
            }
        }
    }

    static class Element
    extends TreeNode {
        private final PropertyAccessor accessor;
        private final int indexInData;

        Element(TreeNode parent, Object metadata, PropertyAccessor accessor, int indexInData) {
            super(parent, metadata);
            this.accessor = accessor;
            this.indexInData = indexInData;
        }

        @Override
        final String getIdentifier() {
            return this.accessor.name(this.indexInData, KeyNamePolicy.UML_IDENTIFIER);
        }

        @Override
        void appendIdentifier(StringBuilder buffer) {
            super.appendIdentifier(buffer);
            buffer.append('.').append(this.accessor.name(this.indexInData, KeyNamePolicy.JAVABEANS_PROPERTY));
        }

        @Override
        CharSequence getName() {
            return CharSequences.camelCaseToSentence(this.getIdentifier()).toString();
        }

        @Override
        public final Class<?> getElementType() {
            return this.accessor.type(this.indexInData, TypeValuePolicy.ELEMENT_TYPE);
        }

        @Override
        public Object getUserObject() {
            return this.accessor.get(this.indexInData, this.metadata);
        }

        @Override
        void setUserObject(Object value) {
            this.accessor.set(this.indexInData, this.metadata, value, 0);
        }

        @Override
        final boolean isWritable() {
            return this.accessor.isWritable(this.indexInData);
        }
    }
}

