/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.AbstractCollection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.TreeNode;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;

final class TreeNodeChildren
extends AbstractCollection<TreeTable.Node> {
    private final TreeNode parent;
    final Object metadata;
    final PropertyAccessor accessor;
    private final TreeNode[] children;
    int modCount;

    TreeNodeChildren(TreeNode parent, Object metadata, PropertyAccessor accessor) {
        this.parent = parent;
        this.metadata = metadata;
        this.accessor = accessor;
        this.children = new TreeNode[accessor.count()];
    }

    final void clearAt(int index) {
        this.accessor.set(index, this.metadata, null, 0);
    }

    final Object valueAt(int index) {
        return this.accessor.get(index, this.metadata);
    }

    final boolean isCollection(int index) {
        return this.accessor.isCollection(index);
    }

    final boolean isSkipped(Object value) {
        return this.parent.table.valuePolicy.isSkipped(value);
    }

    final TreeNode childAt(int index, int subIndex) {
        TreeNode node = this.children[index];
        if (subIndex >= 0) {
            if (node == null || ((TreeNode.CollectionElement)node).indexInList != subIndex) {
                node = new TreeNode.CollectionElement(this.parent, this.metadata, this.accessor, index, subIndex);
                node.init();
            }
        } else if (node == null) {
            node = new TreeNode.Element(this.parent, this.metadata, this.accessor, index);
            node.init();
        }
        this.children[index] = node;
        return node;
    }

    final int childCount() {
        return this.children.length;
    }

    @Override
    public int size() {
        return this.accessor.count(this.metadata, this.parent.table.valuePolicy, 2);
    }

    @Override
    public boolean isEmpty() {
        return this.accessor.count(this.metadata, this.parent.table.valuePolicy, 0) == 0;
    }

    @Override
    public void clear() {
        int i = this.childCount();
        while (--i >= 0) {
            this.clearAt(i);
        }
    }

    @Override
    public Iterator<TreeTable.Node> iterator() {
        return new Iter();
    }

    @Override
    public boolean add(TreeTable.Node node) throws IllegalStateException {
        String identifier = node.getValue(TableColumn.IDENTIFIER);
        if (identifier == null) {
            throw new IllegalArgumentException(Errors.format((short)65, TableColumn.IDENTIFIER.getHeader()));
        }
        return this.add(this.accessor.indexOf(identifier, true), node.getValue(TableColumn.VALUE));
    }

    final boolean add(int index, Object value) throws IllegalStateException {
        if (ValueExistencePolicy.isNullOrEmpty(value)) {
            return false;
        }
        Boolean changed = (Boolean)this.accessor.set(index, this.metadata, value, 2);
        if (changed == null) {
            throw new IllegalStateException(Errors.format((short)131, this.accessor.name(index, KeyNamePolicy.UML_IDENTIFIER)));
        }
        if (changed.booleanValue()) {
            ++this.modCount;
        }
        return changed;
    }

    @Override
    public String toString() {
        String lineSeparator = JDK7.lineSeparator();
        StringBuilder buffer = new StringBuilder(512);
        this.parent.toString(buffer);
        buffer.append(lineSeparator);
        for (TreeTable.Node node : this) {
            buffer.append("  ");
            ((TreeNode)node).toString(buffer);
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    private final class Iter
    implements Iterator<TreeTable.Node> {
        private int nextInAccessor;
        private int previousInAccessor = -1;
        private boolean isNextVerified;
        private Object nextValue;
        private Iterator<?> subIterator;
        private int subIndex = -1;
        private int modCountCheck;

        Iter() {
            this.modCountCheck = TreeNodeChildren.this.modCount;
        }

        final void checkConcurrentModification() {
            if (this.modCountCheck != TreeNodeChildren.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkConcurrentModification();
            if (this.isNextVerified) {
                return true;
            }
            if (this.subIterator != null) {
                if (this.subIterator.hasNext()) {
                    this.nextValue = this.subIterator.next();
                    ++this.subIndex;
                    this.isNextVerified = true;
                    return true;
                }
                this.subIterator = null;
                this.subIndex = -1;
                ++this.nextInAccessor;
            }
            int count = TreeNodeChildren.this.childCount();
            while (this.nextInAccessor < count) {
                this.nextValue = TreeNodeChildren.this.valueAt(this.nextInAccessor);
                if (!TreeNodeChildren.this.isSkipped(this.nextValue)) {
                    if (TreeNodeChildren.this.isCollection(this.nextInAccessor)) {
                        this.subIterator = this.nextValue != null ? ((Iterable)this.nextValue).iterator() : Collections.emptySet().iterator();
                        this.subIndex = 0;
                        this.nextValue = this.subIterator.hasNext() ? this.subIterator.next() : null;
                    }
                    this.isNextVerified = true;
                    return true;
                }
                ++this.nextInAccessor;
            }
            return false;
        }

        @Override
        public TreeTable.Node next() {
            if (this.hasNext()) {
                TreeNode node = TreeNodeChildren.this.childAt(this.nextInAccessor, this.subIndex);
                node.cachedValue = this.nextValue;
                this.previousInAccessor = this.nextInAccessor++;
                if (this.subIterator == null) {
                    // empty if block
                }
                this.isNextVerified = false;
                return node;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.previousInAccessor < 0) {
                throw new IllegalStateException();
            }
            this.checkConcurrentModification();
            if (this.subIterator != null) {
                this.subIterator.remove();
            } else {
                TreeNodeChildren.this.clearAt(this.previousInAccessor);
                this.previousInAccessor = -1;
            }
            this.modCountCheck = ++TreeNodeChildren.this.modCount;
        }
    }
}

