/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.TreeNode;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTableFormat;

final class TreeTableView
implements TreeTable,
Serializable {
    private static final long serialVersionUID = 6320615192545089879L;
    static final List<TableColumn<?>> COLUMNS = UnmodifiableArrayList.wrap(new TableColumn[]{TableColumn.IDENTIFIER, TableColumn.INDEX, TableColumn.NAME, TableColumn.TYPE, TableColumn.VALUE});
    private static Format format;
    private transient TreeNode root;
    final MetadataStandard standard;
    final ValueExistencePolicy valuePolicy;

    TreeTableView(MetadataStandard standard, Object metadata, ValueExistencePolicy valuePolicy) {
        this.standard = standard;
        this.valuePolicy = valuePolicy;
        this.root = new TreeNode(this, metadata);
    }

    @Override
    public List<TableColumn<?>> getColumns() {
        return COLUMNS;
    }

    @Override
    public TreeTable.Node getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Class<TreeTableView> clazz = TreeTableView.class;
        synchronized (TreeTableView.class) {
            String string;
            block8: {
                if (format == null) {
                    TreeTableFormat f = new TreeTableFormat(Locale.getDefault(), TimeZone.getDefault());
                    f.setColumns(TableColumn.NAME, TableColumn.VALUE);
                    format = f;
                }
                boolean allowNull = Semaphores.queryAndSet((byte)4);
                try {
                    string = format.format(this);
                    if (allowNull) break block8;
                }
                catch (Throwable throwable) {
                    if (!allowNull) {
                        Semaphores.clear((byte)4);
                    }
                    throw throwable;
                }
                Semaphores.clear((byte)4);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return string;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.root.metadata);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.root = new TreeNode(this, in.readObject());
    }
}

