/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;

public enum ValueExistencePolicy {
    ALL{

        @Override
        boolean isSkipped(Object value) {
            return false;
        }

        @Override
        boolean substituteByNullElement(Collection<?> values) {
            return values == null || values.isEmpty();
        }
    }
    ,
    NON_NULL{

        @Override
        boolean isSkipped(Object value) {
            return value == null;
        }

        @Override
        boolean substituteByNullElement(Collection<?> values) {
            return values != null && values.isEmpty();
        }
    }
    ,
    NON_NIL{

        @Override
        boolean isSkipped(Object value) {
            return value == null || value instanceof NilObject || NilReason.forObject(value) != null;
        }

        @Override
        boolean substituteByNullElement(Collection<?> values) {
            return values != null && values.isEmpty();
        }
    }
    ,
    NON_EMPTY{

        @Override
        boolean isSkipped(Object value) {
            return 4.isNullOrEmpty(value);
        }

        @Override
        boolean substituteByNullElement(Collection<?> values) {
            return false;
        }
    };


    abstract boolean isSkipped(Object var1);

    abstract boolean substituteByNullElement(Collection<?> var1);

    static boolean isNullOrEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof NilObject) {
            return true;
        }
        if (value instanceof CharSequence) {
            return ValueExistencePolicy.isEmpty((CharSequence)value);
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return NilReason.forObject(value) != null;
    }

    private static boolean isEmpty(CharSequence value) {
        int c;
        int length = value.length();
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = Character.codePointAt(value, i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }
}

