/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.net.URI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.ApplicationSchemaInformation;
import org.opengis.metadata.citation.Citation;

@XmlType(name="MD_ApplicationSchemaInformation_Type", propOrder={"name", "schemaLanguage", "constraintLanguage", "schemaAscii", "graphicsFile", "softwareDevelopmentFile", "softwareDevelopmentFileFormat"})
@XmlRootElement(name="MD_ApplicationSchemaInformation")
public class DefaultApplicationSchemaInformation
extends ISOMetadata
implements ApplicationSchemaInformation {
    private static final long serialVersionUID = -884081423040392985L;
    private Citation name;
    private String schemaLanguage;
    private String constraintLanguage;
    private URI schemaAscii;
    private URI graphicsFile;
    private URI softwareDevelopmentFile;
    private String softwareDevelopmentFileFormat;

    public DefaultApplicationSchemaInformation() {
    }

    public DefaultApplicationSchemaInformation(Citation name, String schemaLanguage, String constraintLanguage) {
        this.name = name;
        this.schemaLanguage = schemaLanguage;
        this.constraintLanguage = constraintLanguage;
    }

    public DefaultApplicationSchemaInformation(ApplicationSchemaInformation object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.schemaLanguage = object.getSchemaLanguage();
            this.constraintLanguage = object.getConstraintLanguage();
            this.schemaAscii = object.getSchemaAscii();
            this.graphicsFile = object.getGraphicsFile();
            this.softwareDevelopmentFile = object.getSoftwareDevelopmentFile();
            this.softwareDevelopmentFileFormat = object.getSoftwareDevelopmentFileFormat();
        }
    }

    public static DefaultApplicationSchemaInformation castOrCopy(ApplicationSchemaInformation object) {
        if (object == null || object instanceof DefaultApplicationSchemaInformation) {
            return (DefaultApplicationSchemaInformation)object;
        }
        return new DefaultApplicationSchemaInformation(object);
    }

    @Override
    @XmlElement(name="name", required=true)
    public Citation getName() {
        return this.name;
    }

    public void setName(Citation newValue) {
        this.checkWritePermission();
        this.name = newValue;
    }

    @Override
    @XmlElement(name="schemaLanguage", required=true)
    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String newValue) {
        this.checkWritePermission();
        this.schemaLanguage = newValue;
    }

    @Override
    @XmlElement(name="constraintLanguage", required=true)
    public String getConstraintLanguage() {
        return this.constraintLanguage;
    }

    public void setConstraintLanguage(String newValue) {
        this.checkWritePermission();
        this.constraintLanguage = newValue;
    }

    @Override
    @XmlElement(name="schemaAscii")
    public URI getSchemaAscii() {
        return this.schemaAscii;
    }

    public void setSchemaAscii(URI newValue) {
        this.checkWritePermission();
        this.schemaAscii = newValue;
    }

    @Override
    @XmlElement(name="graphicsFile")
    public URI getGraphicsFile() {
        return this.graphicsFile;
    }

    public void setGraphicsFile(URI newValue) {
        this.checkWritePermission();
        this.graphicsFile = newValue;
    }

    @Override
    @XmlElement(name="softwareDevelopmentFile")
    public URI getSoftwareDevelopmentFile() {
        return this.softwareDevelopmentFile;
    }

    public void setSoftwareDevelopmentFile(URI newValue) {
        this.checkWritePermission();
        this.softwareDevelopmentFile = newValue;
    }

    @Override
    @XmlElement(name="softwareDevelopmentFileFormat")
    public String getSoftwareDevelopmentFileFormat() {
        return this.softwareDevelopmentFileFormat;
    }

    public void setSoftwareDevelopmentFileFormat(String newValue) {
        this.checkWritePermission();
        this.softwareDevelopmentFileFormat = newValue;
    }
}

