/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Datatype;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.Obligation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.util.InternationalString;

@XmlType(name="MD_ExtendedElementInformation_Type", propOrder={"name", "shortName", "domainCode", "definition", "obligation", "condition", "dataType", "maximumOccurrence", "domainValue", "parentEntity", "rule", "rationales", "sources"})
@XmlRootElement(name="MD_ExtendedElementInformation")
public class DefaultExtendedElementInformation
extends ISOMetadata
implements ExtendedElementInformation {
    private static final long serialVersionUID = 5892811836634834434L;
    private String name;
    @Deprecated
    private String shortName;
    @Deprecated
    private Integer domainCode;
    private InternationalString definition;
    private Obligation obligation;
    private InternationalString condition;
    private Datatype dataType;
    private Integer maximumOccurrence;
    private InternationalString domainValue;
    private Collection<String> parentEntity;
    private InternationalString rule;
    private Collection<InternationalString> rationales;
    private Collection<ResponsibleParty> sources;

    public DefaultExtendedElementInformation() {
    }

    public DefaultExtendedElementInformation(String name, CharSequence definition, CharSequence condition, Datatype dataType, String parentEntity, CharSequence rule, ResponsibleParty source) {
        this.name = name;
        this.definition = Types.toInternationalString(definition);
        this.condition = Types.toInternationalString(condition);
        this.dataType = dataType;
        this.parentEntity = this.singleton(parentEntity, String.class);
        this.rule = Types.toInternationalString(rule);
        this.sources = this.singleton(source, ResponsibleParty.class);
    }

    public DefaultExtendedElementInformation(ExtendedElementInformation object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.shortName = object.getShortName();
            this.domainCode = object.getDomainCode();
            this.definition = object.getDefinition();
            this.obligation = object.getObligation();
            this.condition = object.getCondition();
            this.dataType = object.getDataType();
            this.maximumOccurrence = object.getMaximumOccurrence();
            this.domainValue = object.getDomainValue();
            this.parentEntity = this.copyCollection(object.getParentEntity(), String.class);
            this.rule = object.getRule();
            this.rationales = this.copyCollection(object.getRationales(), InternationalString.class);
            this.sources = this.copyCollection(object.getSources(), ResponsibleParty.class);
        }
    }

    public static DefaultExtendedElementInformation castOrCopy(ExtendedElementInformation object) {
        if (object == null || object instanceof DefaultExtendedElementInformation) {
            return (DefaultExtendedElementInformation)object;
        }
        return new DefaultExtendedElementInformation(object);
    }

    @Override
    @XmlElement(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        this.checkWritePermission();
        this.name = newValue;
    }

    @Override
    @Deprecated
    @XmlElement(name="shortName")
    public String getShortName() {
        return this.shortName;
    }

    @Deprecated
    public void setShortName(String newValue) {
        this.checkWritePermission();
        this.shortName = newValue;
    }

    @Override
    @Deprecated
    @XmlElement(name="domainCode")
    public Integer getDomainCode() {
        return this.domainCode;
    }

    @Deprecated
    public void setDomainCode(Integer newValue) {
        this.checkWritePermission();
        this.domainCode = newValue;
    }

    @Override
    @XmlElement(name="definition", required=true)
    public InternationalString getDefinition() {
        return this.definition;
    }

    public void setDefinition(InternationalString newValue) {
        this.checkWritePermission();
        this.definition = newValue;
    }

    @Override
    @XmlElement(name="obligation")
    public Obligation getObligation() {
        return this.obligation;
    }

    public void setObligation(Obligation newValue) {
        this.checkWritePermission();
        this.obligation = newValue;
    }

    @Override
    @XmlElement(name="condition")
    public InternationalString getCondition() {
        return this.condition;
    }

    public void setCondition(InternationalString newValue) {
        this.checkWritePermission();
        this.condition = newValue;
    }

    @Override
    @XmlElement(name="dataType", required=true)
    public Datatype getDataType() {
        return this.dataType;
    }

    public void setDataType(Datatype newValue) {
        this.checkWritePermission();
        this.dataType = newValue;
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="maximumOccurrence")
    public Integer getMaximumOccurrence() {
        return this.maximumOccurrence;
    }

    public void setMaximumOccurrence(Integer newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultExtendedElementInformation.class, "maximumOccurrence", false, newValue)) {
            this.maximumOccurrence = newValue;
        }
    }

    @Override
    @XmlElement(name="domainValue")
    public InternationalString getDomainValue() {
        return this.domainValue;
    }

    public void setDomainValue(InternationalString newValue) {
        this.checkWritePermission();
        this.domainValue = newValue;
    }

    @Override
    @XmlElement(name="parentEntity", required=true)
    public Collection<String> getParentEntity() {
        this.parentEntity = this.nonNullCollection(this.parentEntity, String.class);
        return this.parentEntity;
    }

    public void setParentEntity(Collection<? extends String> newValues) {
        this.parentEntity = this.writeCollection(newValues, this.parentEntity, String.class);
    }

    @Override
    @XmlElement(name="rule", required=true)
    public InternationalString getRule() {
        return this.rule;
    }

    public void setRule(InternationalString newValue) {
        this.checkWritePermission();
        this.rule = newValue;
    }

    @UML(identifier="rationale", obligation=org.opengis.annotation.Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getRationale() {
        return LegacyPropertyAdapter.getSingleton(this.rationales, InternationalString.class, null, DefaultExtendedElementInformation.class, "getRationale");
    }

    public void setRationale(InternationalString newValue) {
        this.rationales = this.writeCollection(LegacyPropertyAdapter.asCollection(newValue), this.rationales, InternationalString.class);
    }

    @Deprecated
    @XmlElement(name="rationale")
    public Collection<InternationalString> getRationales() {
        this.rationales = this.nonNullCollection(this.rationales, InternationalString.class);
        return this.rationales;
    }

    @Deprecated
    public void setRationales(Collection<? extends InternationalString> newValues) {
        this.rationales = this.writeCollection(newValues, this.rationales, InternationalString.class);
    }

    @XmlElement(name="source", required=true)
    public Collection<ResponsibleParty> getSources() {
        this.sources = this.nonNullCollection(this.sources, ResponsibleParty.class);
        return this.sources;
    }

    public void setSources(Collection<? extends ResponsibleParty> newValues) {
        this.sources = this.writeCollection(newValues, this.sources, ResponsibleParty.class);
    }
}

