/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.code.PT_Locale;
import org.apache.sis.internal.jaxb.gmi.MI_Metadata;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.internal.metadata.OtherLocales;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadataScope;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.MetadataScopeAdapter;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.ApplicationSchemaInformation;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.MetadataExtensionInformation;
import org.opengis.metadata.PortrayalCatalogueReference;
import org.opengis.metadata.acquisition.AcquisitionInformation;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Metadata_Type", propOrder={"fileIdentifier", "language", "characterSet", "parentIdentifier", "hierarchyLevels", "hierarchyLevelNames", "contacts", "dateStamp", "metadataStandardName", "metadataStandardVersion", "dataSetUri", "locales", "spatialRepresentationInfo", "referenceSystemInfo", "metadataExtensionInfo", "identificationInfo", "contentInfo", "distributionInfo", "dataQualityInfo", "portrayalCatalogueInfo", "metadataConstraints", "applicationSchemaInfo", "metadataMaintenance", "acquisitionInformation"})
@XmlRootElement(name="MD_Metadata")
@XmlSeeAlso(value={MI_Metadata.class})
public class DefaultMetadata
extends ISOMetadata
implements Metadata {
    private static final long serialVersionUID = 7337533776231004504L;
    private Identifier metadataIdentifier;
    private Collection<Locale> languages;
    private Collection<Charset> characterSets;
    private Citation parentMetadata;
    private Collection<DefaultMetadataScope> metadataScopes;
    private Collection<ResponsibleParty> contacts;
    private Collection<CitationDate> dateInfo;
    private Collection<Citation> metadataStandards;
    private Collection<Citation> metadataProfiles;
    private Collection<Citation> alternativeMetadataReferences;
    private Collection<OnlineResource> metadataLinkages;
    private Collection<SpatialRepresentation> spatialRepresentationInfo;
    private Collection<ReferenceSystem> referenceSystemInfo;
    private Collection<MetadataExtensionInformation> metadataExtensionInfo;
    private Collection<Identification> identificationInfo;
    private Collection<ContentInformation> contentInfo;
    private Distribution distributionInfo;
    private Collection<DataQuality> dataQualityInfo;
    private Collection<PortrayalCatalogueReference> portrayalCatalogueInfo;
    private Collection<Constraints> metadataConstraints;
    private Collection<ApplicationSchemaInformation> applicationSchemaInfo;
    private MaintenanceInformation metadataMaintenance;
    private Collection<AcquisitionInformation> acquisitionInformation;
    private Collection<Lineage> resourceLineages;

    public DefaultMetadata() {
    }

    public DefaultMetadata(ResponsibleParty contact, Date dateStamp, Identification identificationInfo) {
        this.contacts = this.singleton(contact, ResponsibleParty.class);
        this.identificationInfo = this.singleton(identificationInfo, Identification.class);
        if (dateStamp != null) {
            this.dateInfo = this.singleton(new DefaultCitationDate(dateStamp, DateType.CREATION), CitationDate.class);
        }
    }

    public DefaultMetadata(Metadata object) {
        super(object);
        if (object != null) {
            this.contacts = this.copyCollection(object.getContacts(), ResponsibleParty.class);
            this.spatialRepresentationInfo = this.copyCollection(object.getSpatialRepresentationInfo(), SpatialRepresentation.class);
            this.referenceSystemInfo = this.copyCollection(object.getReferenceSystemInfo(), ReferenceSystem.class);
            this.metadataExtensionInfo = this.copyCollection(object.getMetadataExtensionInfo(), MetadataExtensionInformation.class);
            this.identificationInfo = this.copyCollection(object.getIdentificationInfo(), Identification.class);
            this.contentInfo = this.copyCollection(object.getContentInfo(), ContentInformation.class);
            this.distributionInfo = object.getDistributionInfo();
            this.dataQualityInfo = this.copyCollection(object.getDataQualityInfo(), DataQuality.class);
            this.portrayalCatalogueInfo = this.copyCollection(object.getPortrayalCatalogueInfo(), PortrayalCatalogueReference.class);
            this.metadataConstraints = this.copyCollection(object.getMetadataConstraints(), Constraints.class);
            this.applicationSchemaInfo = this.copyCollection(object.getApplicationSchemaInfo(), ApplicationSchemaInformation.class);
            this.metadataMaintenance = object.getMetadataMaintenance();
            this.acquisitionInformation = this.copyCollection(object.getAcquisitionInformation(), AcquisitionInformation.class);
            if (object instanceof DefaultMetadata) {
                DefaultMetadata c = (DefaultMetadata)object;
                this.metadataIdentifier = c.getMetadataIdentifier();
                this.parentMetadata = c.getParentMetadata();
                this.languages = this.copyCollection(c.getLanguages(), Locale.class);
                this.characterSets = this.copyCollection(c.getCharacterSets(), Charset.class);
                this.metadataScopes = this.copyCollection(c.getMetadataScopes(), DefaultMetadataScope.class);
                this.dateInfo = this.copyCollection(c.getDateInfo(), CitationDate.class);
                this.metadataStandards = this.copyCollection(c.getMetadataStandards(), Citation.class);
                this.metadataProfiles = this.copyCollection(c.getMetadataProfiles(), Citation.class);
                this.alternativeMetadataReferences = this.copyCollection(c.getAlternativeMetadataReferences(), Citation.class);
                this.metadataLinkages = this.copyCollection(c.getMetadataLinkages(), OnlineResource.class);
                this.resourceLineages = this.copyCollection(c.getResourceLineages(), Lineage.class);
            } else {
                this.setFileIdentifier(object.getFileIdentifier());
                this.setParentIdentifier(object.getParentIdentifier());
                this.setLanguage(object.getLanguage());
                this.setLocales(object.getLocales());
                this.setCharacterSet(object.getCharacterSet());
                this.setHierarchyLevels(object.getHierarchyLevels());
                this.setHierarchyLevelNames(object.getHierarchyLevelNames());
                this.setDateStamp(object.getDateStamp());
                this.setMetadataStandardName(object.getMetadataStandardName());
                this.setMetadataStandardVersion(object.getMetadataStandardVersion());
                try {
                    this.setDataSetUri(object.getDataSetUri());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    public static DefaultMetadata castOrCopy(Metadata object) {
        if (object == null || object instanceof DefaultMetadata) {
            return (DefaultMetadata)object;
        }
        return new DefaultMetadata(object);
    }

    @UML(identifier="metadataIdentifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getMetadataIdentifier() {
        return this.metadataIdentifier;
    }

    public void setMetadataIdentifier(Identifier newValue) {
        this.checkWritePermission();
        this.metadataIdentifier = newValue;
    }

    @Override
    @Deprecated
    @XmlElement(name="fileIdentifier")
    public String getFileIdentifier() {
        Identifier identifier = this.getMetadataIdentifier();
        return identifier != null ? identifier.getCode() : null;
    }

    @Deprecated
    public void setFileIdentifier(String newValue) {
        DefaultIdentifier identifier = DefaultIdentifier.castOrCopy(this.metadataIdentifier);
        if (identifier == null) {
            if (newValue == null) {
                return;
            }
            identifier = new DefaultIdentifier();
        }
        identifier.setCode(newValue);
        if (newValue == null && identifier instanceof AbstractMetadata && identifier.isEmpty()) {
            identifier = null;
        }
        this.setMetadataIdentifier(identifier);
    }

    @UML(identifier="defaultLocale+otherLocale", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<Locale> getLanguages() {
        this.languages = this.nonNullCollection(this.languages, Locale.class);
        return this.languages;
    }

    public void setLanguages(Collection<Locale> newValues) {
        this.languages = this.writeCollection(newValues, this.languages, Locale.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="language")
    public Locale getLanguage() {
        return CollectionsExt.first(this.getLanguages());
    }

    @Deprecated
    public void setLanguage(Locale newValue) {
        this.checkWritePermission();
        this.setLanguages(OtherLocales.setFirst(this.languages, newValue));
    }

    @Override
    @Deprecated
    @XmlElement(name="locale")
    @XmlJavaTypeAdapter(value=PT_Locale.class)
    public Collection<Locale> getLocales() {
        return OtherLocales.filter(this.getLanguages());
    }

    @Deprecated
    public void setLocales(Collection<? extends Locale> newValues) {
        this.checkWritePermission();
        this.setLanguages(OtherLocales.merge(CollectionsExt.first(this.languages), newValues));
    }

    @UML(identifier="characterSet", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<Charset> getCharacterSets() {
        this.characterSets = this.nonNullCollection(this.characterSets, Charset.class);
        return this.characterSets;
    }

    public void setCharacterSets(Collection<Charset> newValues) {
        this.characterSets = this.writeCollection(newValues, this.characterSets, Charset.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="characterSet")
    public CharacterSet getCharacterSet() {
        Charset cs = LegacyPropertyAdapter.getSingleton(this.getCharacterSets(), Charset.class, null, DefaultMetadata.class, "getCharacterSet");
        if (cs == null) {
            return null;
        }
        String name = cs.name();
        for (CharacterSet candidate : CharacterSet.values()) {
            for (String n : candidate.names()) {
                if (!name.equals(n)) continue;
                return candidate;
            }
        }
        return CharacterSet.valueOf(name);
    }

    @Deprecated
    public void setCharacterSet(CharacterSet newValue) {
        this.setCharacterSets(LegacyPropertyAdapter.asCollection(newValue != null ? newValue.toCharset() : null));
    }

    @UML(identifier="parentMetadata", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Citation getParentMetadata() {
        return this.parentMetadata;
    }

    public void setParentMetadata(Citation newValue) {
        this.checkWritePermission();
        this.parentMetadata = newValue;
    }

    @Override
    @Deprecated
    @XmlElement(name="parentIdentifier")
    public String getParentIdentifier() {
        InternationalString title;
        Citation parentMetadata = this.getParentMetadata();
        if (parentMetadata != null && (title = parentMetadata.getTitle()) != null) {
            return title.toString();
        }
        return null;
    }

    @Deprecated
    public void setParentIdentifier(String newValue) {
        this.checkWritePermission();
        DefaultCitation parent = DefaultCitation.castOrCopy(this.parentMetadata);
        if (parent == null) {
            parent = new DefaultCitation();
        }
        parent.setTitle(new SimpleInternationalString(newValue));
        this.setParentMetadata(parent);
    }

    @UML(identifier="metadataScope", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultMetadataScope> getMetadataScopes() {
        this.metadataScopes = this.nonNullCollection(this.metadataScopes, DefaultMetadataScope.class);
        return this.metadataScopes;
    }

    public void setMetadataScopes(Collection<? extends DefaultMetadataScope> newValues) {
        this.metadataScopes = this.writeCollection(newValues, this.metadataScopes, DefaultMetadataScope.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="hierarchyLevel")
    public final Collection<ScopeCode> getHierarchyLevels() {
        return new MetadataScopeAdapter<ScopeCode>(this.getMetadataScopes()){

            @Override
            protected DefaultMetadataScope wrap(ScopeCode value) {
                return new DefaultMetadataScope(value, null);
            }

            @Override
            protected ScopeCode unwrap(DefaultMetadataScope container) {
                return container.getResourceScope();
            }

            @Override
            protected boolean update(DefaultMetadataScope container, ScopeCode value) {
                container.setResourceScope(value);
                return true;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setHierarchyLevels(Collection<? extends ScopeCode> newValues) {
        this.checkWritePermission();
        ((LegacyPropertyAdapter)this.getHierarchyLevels()).setValues(newValues);
    }

    @Override
    @Deprecated
    @XmlElement(name="hierarchyLevelName")
    public final Collection<String> getHierarchyLevelNames() {
        return new MetadataScopeAdapter<String>(this.getMetadataScopes()){

            @Override
            protected DefaultMetadataScope wrap(String value) {
                return new DefaultMetadataScope(null, value);
            }

            @Override
            protected String unwrap(DefaultMetadataScope container) {
                InternationalString name = container.getName();
                return name != null ? name.toString() : null;
            }

            @Override
            protected boolean update(DefaultMetadataScope container, String value) {
                container.setName(value != null ? new SimpleInternationalString(value) : null);
                return true;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setHierarchyLevelNames(Collection<? extends String> newValues) {
        this.checkWritePermission();
        ((LegacyPropertyAdapter)this.getHierarchyLevelNames()).setValues(newValues);
    }

    @XmlElement(name="contact", required=true)
    public Collection<ResponsibleParty> getContacts() {
        this.contacts = this.nonNullCollection(this.contacts, ResponsibleParty.class);
        return this.contacts;
    }

    public void setContacts(Collection<? extends ResponsibleParty> newValues) {
        this.checkWritePermission();
        this.contacts = this.writeCollection(newValues, this.contacts, ResponsibleParty.class);
    }

    @UML(identifier="dateInfo", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<CitationDate> getDateInfo() {
        this.dateInfo = this.nonNullCollection(this.dateInfo, CitationDate.class);
        return this.dateInfo;
    }

    public void setDateInfo(Collection<? extends CitationDate> newValues) {
        this.dateInfo = this.writeCollection(newValues, this.dateInfo, CitationDate.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="dateStamp", required=true)
    public Date getDateStamp() {
        Collection<CitationDate> dates = this.getDateInfo();
        if (dates != null) {
            for (CitationDate date : dates) {
                if (!DateType.CREATION.equals(date.getDateType())) continue;
                return date.getDate();
            }
        }
        return null;
    }

    @Deprecated
    public void setDateStamp(Date newValue) {
        this.checkWritePermission();
        Collection<CitationDate> newValues = this.dateInfo;
        if (newValues == null) {
            if (newValue == null) {
                return;
            }
            newValues = new ArrayList<CitationDate>(1);
        } else {
            Iterator<CitationDate> it = newValues.iterator();
            while (it.hasNext()) {
                CitationDate date = it.next();
                if (!DateType.CREATION.equals(date.getDateType())) continue;
                if (newValue == null) {
                    it.remove();
                    return;
                }
                if (date instanceof DefaultCitationDate) {
                    ((DefaultCitationDate)date).setDate(newValue);
                    return;
                }
                it.remove();
                break;
            }
        }
        newValues.add(new DefaultCitationDate(newValue, DateType.CREATION));
        this.setDateInfo(newValues);
    }

    @UML(identifier="metadataStandard", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getMetadataStandards() {
        this.metadataStandards = this.nonNullCollection(this.metadataStandards, Citation.class);
        return this.metadataStandards;
    }

    public void setMetadataStandards(Collection<? extends Citation> newValues) {
        this.metadataStandards = this.writeCollection(newValues, this.metadataStandards, Citation.class);
    }

    @UML(identifier="metadataProfile", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getMetadataProfiles() {
        this.metadataProfiles = this.nonNullCollection(this.metadataProfiles, Citation.class);
        return this.metadataProfiles;
    }

    public void setMetadataProfiles(Collection<? extends Citation> newValues) {
        this.metadataProfiles = this.writeCollection(newValues, this.metadataProfiles, Citation.class);
    }

    @UML(identifier="alternativeMetadataReference", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getAlternativeMetadataReferences() {
        this.alternativeMetadataReferences = this.nonNullCollection(this.alternativeMetadataReferences, Citation.class);
        return this.alternativeMetadataReferences;
    }

    public void setAlternativeMetadataReferences(Collection<? extends Citation> newValues) {
        this.alternativeMetadataReferences = this.writeCollection(newValues, this.alternativeMetadataReferences, Citation.class);
    }

    private String getMetadataStandard(boolean version) {
        Citation standard = LegacyPropertyAdapter.getSingleton(this.getMetadataStandards(), Citation.class, null, DefaultMetadata.class, version ? "getMetadataStandardName" : "getMetadataStandardVersion");
        if (standard != null) {
            InternationalString title;
            InternationalString internationalString = title = version ? standard.getEdition() : standard.getTitle();
            if (title != null) {
                return title.toString();
            }
        }
        return null;
    }

    private void setMetadataStandard(boolean version, String newValue) {
        DefaultCitation citation;
        this.checkWritePermission();
        SimpleInternationalString i18n = newValue != null ? new SimpleInternationalString(newValue) : null;
        ArrayList<Citation> newValues = this.metadataStandards != null ? new ArrayList<Citation>(this.metadataStandards) : new ArrayList(1);
        DefaultCitation defaultCitation = citation = newValues.isEmpty() ? null : DefaultCitation.castOrCopy((Citation)newValues.get(0));
        if (citation == null) {
            citation = new DefaultCitation();
        }
        if (version) {
            citation.setEdition(i18n);
        } else {
            citation.setTitle(i18n);
        }
        if (newValues.isEmpty()) {
            newValues.add(citation);
        } else {
            newValues.set(0, citation);
        }
        this.setMetadataStandards(newValues);
    }

    @Override
    @Deprecated
    @XmlElement(name="metadataStandardName")
    public String getMetadataStandardName() {
        return this.getMetadataStandard(false);
    }

    @Deprecated
    public void setMetadataStandardName(String newValue) {
        this.setMetadataStandard(false, newValue);
    }

    @Override
    @Deprecated
    @XmlElement(name="metadataStandardVersion")
    public String getMetadataStandardVersion() {
        return this.getMetadataStandard(true);
    }

    @Deprecated
    public void setMetadataStandardVersion(String newValue) {
        this.setMetadataStandard(true, newValue);
    }

    @UML(identifier="metadataLinkage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<OnlineResource> getMetadataLinkages() {
        this.metadataLinkages = this.nonNullCollection(this.metadataLinkages, OnlineResource.class);
        return this.metadataLinkages;
    }

    public void setMetadataLinkages(Collection<? extends OnlineResource> newValues) {
        this.metadataLinkages = this.writeCollection(newValues, this.metadataLinkages, OnlineResource.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="dataSetURI")
    public String getDataSetUri() {
        String linkage = null;
        Collection<Identification> info = this.getIdentificationInfo();
        if (info != null) {
            block0: for (Identification identification : info) {
                Collection<OnlineResource> onlineResources;
                Citation citation = identification.getCitation();
                if (!(citation instanceof DefaultCitation) || (onlineResources = ((DefaultCitation)citation).getOnlineResources()) == null) continue;
                for (OnlineResource link : onlineResources) {
                    URI uri = link.getLinkage();
                    if (uri == null) continue;
                    if (linkage == null) {
                        linkage = uri.toString();
                        continue;
                    }
                    LegacyPropertyAdapter.warnIgnoredExtraneous(OnlineResource.class, DefaultMetadata.class, "getDataSetUri");
                    continue block0;
                }
            }
        }
        return linkage;
    }

    @Deprecated
    public void setDataSetUri(String newValue) throws URISyntaxException {
        Collection<OnlineResource> onlineResources;
        DefaultOnlineResource firstOnline;
        DefaultCitation citation;
        URI uri = new URI(newValue);
        this.checkWritePermission();
        Collection<Identification> info = this.identificationInfo;
        AbstractIdentification firstId = AbstractIdentification.castOrCopy(CollectionsExt.first(info));
        if (firstId == null) {
            firstId = new DefaultDataIdentification();
        }
        if ((citation = DefaultCitation.castOrCopy(firstId.getCitation())) == null) {
            citation = new DefaultCitation();
        }
        if ((firstOnline = DefaultOnlineResource.castOrCopy(CollectionsExt.first(onlineResources = citation.getOnlineResources()))) == null) {
            firstOnline = new DefaultOnlineResource();
        }
        firstOnline.setLinkage(uri);
        onlineResources = OtherLocales.setFirst(onlineResources, firstOnline);
        citation.setOnlineResources(onlineResources);
        firstId.setCitation(citation);
        info = OtherLocales.setFirst(info, firstId);
        this.setIdentificationInfo(info);
    }

    @XmlElement(name="spatialRepresentationInfo")
    public Collection<SpatialRepresentation> getSpatialRepresentationInfo() {
        this.spatialRepresentationInfo = this.nonNullCollection(this.spatialRepresentationInfo, SpatialRepresentation.class);
        return this.spatialRepresentationInfo;
    }

    public void setSpatialRepresentationInfo(Collection<? extends SpatialRepresentation> newValues) {
        this.spatialRepresentationInfo = this.writeCollection(newValues, this.spatialRepresentationInfo, SpatialRepresentation.class);
    }

    @XmlElement(name="referenceSystemInfo")
    public Collection<ReferenceSystem> getReferenceSystemInfo() {
        this.referenceSystemInfo = this.nonNullCollection(this.referenceSystemInfo, ReferenceSystem.class);
        return this.referenceSystemInfo;
    }

    public void setReferenceSystemInfo(Collection<? extends ReferenceSystem> newValues) {
        this.referenceSystemInfo = this.writeCollection(newValues, this.referenceSystemInfo, ReferenceSystem.class);
    }

    @XmlElement(name="metadataExtensionInfo")
    public Collection<MetadataExtensionInformation> getMetadataExtensionInfo() {
        this.metadataExtensionInfo = this.nonNullCollection(this.metadataExtensionInfo, MetadataExtensionInformation.class);
        return this.metadataExtensionInfo;
    }

    public void setMetadataExtensionInfo(Collection<? extends MetadataExtensionInformation> newValues) {
        this.metadataExtensionInfo = this.writeCollection(newValues, this.metadataExtensionInfo, MetadataExtensionInformation.class);
    }

    @XmlElement(name="identificationInfo", required=true)
    public Collection<Identification> getIdentificationInfo() {
        this.identificationInfo = this.nonNullCollection(this.identificationInfo, Identification.class);
        return this.identificationInfo;
    }

    public void setIdentificationInfo(Collection<? extends Identification> newValues) {
        this.identificationInfo = this.writeCollection(newValues, this.identificationInfo, Identification.class);
    }

    @XmlElement(name="contentInfo")
    public Collection<ContentInformation> getContentInfo() {
        this.contentInfo = this.nonNullCollection(this.contentInfo, ContentInformation.class);
        return this.contentInfo;
    }

    public void setContentInfo(Collection<? extends ContentInformation> newValues) {
        this.contentInfo = this.writeCollection(newValues, this.contentInfo, ContentInformation.class);
    }

    @Override
    @XmlElement(name="distributionInfo")
    public Distribution getDistributionInfo() {
        return this.distributionInfo;
    }

    public void setDistributionInfo(Distribution newValue) {
        this.checkWritePermission();
        this.distributionInfo = newValue;
    }

    @XmlElement(name="dataQualityInfo")
    public Collection<DataQuality> getDataQualityInfo() {
        this.dataQualityInfo = this.nonNullCollection(this.dataQualityInfo, DataQuality.class);
        return this.dataQualityInfo;
    }

    public void setDataQualityInfo(Collection<? extends DataQuality> newValues) {
        this.dataQualityInfo = this.writeCollection(newValues, this.dataQualityInfo, DataQuality.class);
    }

    @XmlElement(name="portrayalCatalogueInfo")
    public Collection<PortrayalCatalogueReference> getPortrayalCatalogueInfo() {
        this.portrayalCatalogueInfo = this.nonNullCollection(this.portrayalCatalogueInfo, PortrayalCatalogueReference.class);
        return this.portrayalCatalogueInfo;
    }

    public void setPortrayalCatalogueInfo(Collection<? extends PortrayalCatalogueReference> newValues) {
        this.portrayalCatalogueInfo = this.writeCollection(newValues, this.portrayalCatalogueInfo, PortrayalCatalogueReference.class);
    }

    @XmlElement(name="metadataConstraints")
    public Collection<Constraints> getMetadataConstraints() {
        this.metadataConstraints = this.nonNullCollection(this.metadataConstraints, Constraints.class);
        return this.metadataConstraints;
    }

    public void setMetadataConstraints(Collection<? extends Constraints> newValues) {
        this.metadataConstraints = this.writeCollection(newValues, this.metadataConstraints, Constraints.class);
    }

    @XmlElement(name="applicationSchemaInfo")
    public Collection<ApplicationSchemaInformation> getApplicationSchemaInfo() {
        this.applicationSchemaInfo = this.nonNullCollection(this.applicationSchemaInfo, ApplicationSchemaInformation.class);
        return this.applicationSchemaInfo;
    }

    public void setApplicationSchemaInfo(Collection<? extends ApplicationSchemaInformation> newValues) {
        this.applicationSchemaInfo = this.writeCollection(newValues, this.applicationSchemaInfo, ApplicationSchemaInformation.class);
    }

    @XmlElement(name="acquisitionInformation", namespace="http://www.isotc211.org/2005/gmi")
    public Collection<AcquisitionInformation> getAcquisitionInformation() {
        this.acquisitionInformation = this.nonNullCollection(this.acquisitionInformation, AcquisitionInformation.class);
        return this.acquisitionInformation;
    }

    public void setAcquisitionInformation(Collection<? extends AcquisitionInformation> newValues) {
        this.acquisitionInformation = this.writeCollection(newValues, this.acquisitionInformation, AcquisitionInformation.class);
    }

    @Override
    @XmlElement(name="metadataMaintenance")
    public MaintenanceInformation getMetadataMaintenance() {
        return this.metadataMaintenance;
    }

    public void setMetadataMaintenance(MaintenanceInformation newValue) {
        this.checkWritePermission();
        this.metadataMaintenance = newValue;
    }

    @UML(identifier="resourceLineage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Lineage> getResourceLineages() {
        this.resourceLineages = this.nonNullCollection(this.resourceLineages, Lineage.class);
        return this.resourceLineages;
    }

    public void setResourceLineages(Collection<? extends Lineage> newValues) {
        this.resourceLineages = this.writeCollection(newValues, this.resourceLineages, Lineage.class);
    }

    private void beforeMarshal(Marshaller marshaller) {
        Context.push(CollectionsExt.first(this.languages));
    }

    private void afterMarshal(Marshaller marshaller) {
        Context.pull();
    }
}

