/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.DefaultMetadataScope;

abstract class MetadataScopeAdapter<L>
extends LegacyPropertyAdapter<L, DefaultMetadataScope> {
    MetadataScopeAdapter(Collection<DefaultMetadataScope> scopes) {
        super(scopes);
    }

    @Override
    public boolean add(L newValue) {
        int n = 0;
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            DefaultMetadataScope scope = (DefaultMetadataScope)it.next();
            if (this.unwrap(scope) != null) {
                ++n;
                continue;
            }
            if (!scope.isModifiable()) {
                scope = new DefaultMetadataScope(scope);
                if (this.elements instanceof List) {
                    ((List)this.elements).set(n, scope);
                } else {
                    DefaultMetadataScope[] remaining = new DefaultMetadataScope[this.elements.size() - n];
                    remaining[0] = scope;
                    n = 1;
                    it.remove();
                    while (it.hasNext()) {
                        remaining[n++] = (DefaultMetadataScope)it.next();
                        it.remove();
                    }
                    if (n != remaining.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.elements.addAll(Arrays.asList(remaining));
                }
            }
            return this.update(scope, newValue);
        }
        return super.add(newValue);
    }
}

