/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.InternationalString;

@XmlType(name="MI_Instrument_Type", propOrder={"citations", "identifier", "type", "description", "mountedOn"})
@XmlRootElement(name="MI_Instrument")
public class DefaultInstrument
extends ISOMetadata
implements Instrument {
    private static final long serialVersionUID = -7439143424271079960L;
    private Collection<Citation> citations;
    private InternationalString type;
    private InternationalString description;
    private Platform mountedOn;

    public DefaultInstrument() {
    }

    public DefaultInstrument(Instrument object) {
        super(object);
        if (object != null) {
            this.citations = this.copyCollection(object.getCitations(), Citation.class);
            this.identifiers = this.singleton(object.getIdentifier(), Identifier.class);
            this.type = object.getType();
            this.description = object.getDescription();
            this.mountedOn = object.getMountedOn();
        }
    }

    public static DefaultInstrument castOrCopy(Instrument object) {
        if (object == null || object instanceof DefaultInstrument) {
            return (DefaultInstrument)object;
        }
        return new DefaultInstrument(object);
    }

    @XmlElement(name="citation")
    public Collection<Citation> getCitations() {
        this.citations = this.nonNullCollection(this.citations, Citation.class);
        return this.citations;
    }

    public void setCitations(Collection<? extends Citation> newValues) {
        this.citations = this.writeCollection(newValues, this.citations, Citation.class);
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return NonMarshalledAuthority.getMarshallable(this.identifiers);
    }

    public void setIdentifier(Identifier newValue) {
        this.checkWritePermission();
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        NonMarshalledAuthority.setMarshallable(this.identifiers, newValue);
    }

    @Override
    @XmlElement(name="type", required=true)
    public InternationalString getType() {
        return this.type;
    }

    public void setType(InternationalString newValue) {
        this.checkWritePermission();
        this.type = newValue;
    }

    @Override
    @XmlElement(name="description")
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    @Override
    @XmlElement(name="mountedOn")
    public Platform getMountedOn() {
        return this.mountedOn;
    }

    public void setMountedOn(Platform newValue) {
        this.checkWritePermission();
        this.mountedOn = newValue;
    }
}

