/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.acquisition.GeometryType;
import org.opengis.metadata.acquisition.Operation;
import org.opengis.metadata.acquisition.Plan;
import org.opengis.metadata.acquisition.Requirement;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.Progress;

@XmlType(name="MI_Plan_Type", propOrder={"type", "status", "citation", "operations", "satisfiedRequirements"})
@XmlRootElement(name="MI_Plan")
public class DefaultPlan
extends ISOMetadata
implements Plan {
    private static final long serialVersionUID = -1212695055582082867L;
    private GeometryType type;
    private Progress status;
    private Citation citation;
    private Collection<Operation> operations;
    private Collection<Requirement> satisfiedRequirements;

    public DefaultPlan() {
    }

    public DefaultPlan(Plan object) {
        super(object);
        if (object != null) {
            this.type = object.getType();
            this.status = object.getStatus();
            this.citation = object.getCitation();
            this.operations = this.copyCollection(object.getOperations(), Operation.class);
            this.satisfiedRequirements = this.copyCollection(object.getSatisfiedRequirements(), Requirement.class);
        }
    }

    public static DefaultPlan castOrCopy(Plan object) {
        if (object == null || object instanceof DefaultPlan) {
            return (DefaultPlan)object;
        }
        return new DefaultPlan(object);
    }

    @Override
    @XmlElement(name="type")
    public GeometryType getType() {
        return this.type;
    }

    public void setType(GeometryType newValue) {
        this.checkWritePermission();
        this.type = newValue;
    }

    @Override
    @XmlElement(name="status", required=true)
    public Progress getStatus() {
        return this.status;
    }

    public void setStatus(Progress newValue) {
        this.checkWritePermission();
        this.status = newValue;
    }

    @Override
    @XmlElement(name="citation", required=true)
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation newValue) {
        this.checkWritePermission();
        this.citation = newValue;
    }

    @XmlElement(name="operation")
    public Collection<Operation> getOperations() {
        this.operations = this.nonNullCollection(this.operations, Operation.class);
        return this.operations;
    }

    public void setOperations(Collection<? extends Operation> newValues) {
        this.operations = this.writeCollection(newValues, this.operations, Operation.class);
    }

    @XmlElement(name="satisfiedRequirement")
    public Collection<Requirement> getSatisfiedRequirements() {
        this.satisfiedRequirements = this.nonNullCollection(this.satisfiedRequirements, Requirement.class);
        return this.satisfiedRequirements;
    }

    public void setSatisfiedRequirements(Collection<? extends Requirement> newValues) {
        this.satisfiedRequirements = this.writeCollection(newValues, this.satisfiedRequirements, Requirement.class);
    }
}

