/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Event;
import org.opengis.metadata.acquisition.PlatformPass;

@XmlType(name="MI_PlatformPass_Type", propOrder={"identifier", "extent", "relatedEvents"})
@XmlRootElement(name="MI_PlatformPass")
public class DefaultPlatformPass
extends ISOMetadata
implements PlatformPass {
    private static final long serialVersionUID = -6447077434254133293L;
    private Geometry extent;
    private Collection<Event> relatedEvents;

    public DefaultPlatformPass() {
    }

    public DefaultPlatformPass(PlatformPass object) {
        super(object);
        if (object != null) {
            this.identifiers = this.singleton(object.getIdentifier(), Identifier.class);
            this.extent = object.getExtent();
            this.relatedEvents = this.copyCollection(object.getRelatedEvents(), Event.class);
        }
    }

    public static DefaultPlatformPass castOrCopy(PlatformPass object) {
        if (object == null || object instanceof DefaultPlatformPass) {
            return (DefaultPlatformPass)object;
        }
        return new DefaultPlatformPass(object);
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return NonMarshalledAuthority.getMarshallable(this.identifiers);
    }

    public void setIdentifier(Identifier newValue) {
        this.checkWritePermission();
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        NonMarshalledAuthority.setMarshallable(this.identifiers, newValue);
    }

    @Override
    @XmlElement(name="extent")
    public Geometry getExtent() {
        return this.extent;
    }

    public void setExtent(Geometry newValue) {
        this.checkWritePermission();
        this.extent = newValue;
    }

    @XmlElement(name="relatedEvent")
    public Collection<Event> getRelatedEvents() {
        this.relatedEvents = this.nonNullCollection(this.relatedEvents, Event.class);
        return this.relatedEvents;
    }

    public void setRelatedEvents(Collection<? extends Event> newValues) {
        this.relatedEvents = this.writeCollection(newValues, this.relatedEvents, Event.class);
    }
}

