/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;

@XmlType(name="CI_Date_Type", propOrder={"date", "dateType"})
@XmlRootElement(name="CI_Date")
public class DefaultCitationDate
extends ISOMetadata
implements CitationDate {
    private static final long serialVersionUID = 5140213754542273710L;
    private long date = Long.MIN_VALUE;
    private DateType dateType;

    public DefaultCitationDate() {
    }

    public DefaultCitationDate(Date date, DateType dateType) {
        this.date = MetadataUtilities.toMilliseconds(date);
        this.dateType = dateType;
    }

    public DefaultCitationDate(CitationDate object) {
        super(object);
        if (object != null) {
            this.date = MetadataUtilities.toMilliseconds(object.getDate());
            this.dateType = object.getDateType();
        }
    }

    public static DefaultCitationDate castOrCopy(CitationDate object) {
        if (object == null || object instanceof DefaultCitationDate) {
            return (DefaultCitationDate)object;
        }
        return new DefaultCitationDate(object);
    }

    @Override
    @XmlElement(name="date", required=true)
    public Date getDate() {
        return MetadataUtilities.toDate(this.date);
    }

    public void setDate(Date newValue) {
        this.checkWritePermission();
        this.date = MetadataUtilities.toMilliseconds(newValue);
    }

    @Override
    @XmlElement(name="dateType", required=true)
    public DateType getDateType() {
        return this.dateType;
    }

    public void setDateType(DateType newValue) {
        this.checkWritePermission();
        this.dateType = newValue;
    }
}

