/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.net.URI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.util.InternationalString;

@XmlType(name="CI_OnlineResource_Type", propOrder={"linkage", "protocol", "applicationProfile", "name", "description", "function"})
@XmlRootElement(name="CI_OnlineResource")
public class DefaultOnlineResource
extends ISOMetadata
implements OnlineResource {
    private static final long serialVersionUID = 1413613911128890864L;
    private URI linkage;
    private String protocol;
    private String applicationProfile;
    private String name;
    private InternationalString description;
    private OnLineFunction function;
    private String protocolRequest;

    public DefaultOnlineResource() {
    }

    public DefaultOnlineResource(URI linkage) {
        this.linkage = linkage;
    }

    public DefaultOnlineResource(OnlineResource object) {
        super(object);
        if (object != null) {
            this.linkage = object.getLinkage();
            this.protocol = object.getProtocol();
            this.applicationProfile = object.getApplicationProfile();
            this.name = object.getName();
            this.description = object.getDescription();
            this.function = object.getFunction();
            if (object instanceof DefaultOnlineResource) {
                this.protocolRequest = ((DefaultOnlineResource)object).getProtocolRequest();
            }
        }
    }

    public static DefaultOnlineResource castOrCopy(OnlineResource object) {
        if (object == null || object instanceof DefaultOnlineResource) {
            return (DefaultOnlineResource)object;
        }
        return new DefaultOnlineResource(object);
    }

    @Override
    @XmlElement(name="applicationProfile")
    public String getApplicationProfile() {
        return this.applicationProfile;
    }

    public void setApplicationProfile(String newValue) {
        this.checkWritePermission();
        this.applicationProfile = newValue;
    }

    @Override
    @XmlElement(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        this.checkWritePermission();
        this.name = newValue;
    }

    @Override
    @XmlElement(name="description")
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    @Override
    @XmlElement(name="function")
    public OnLineFunction getFunction() {
        return this.function;
    }

    public void setFunction(OnLineFunction newValue) {
        this.checkWritePermission();
        this.function = newValue;
    }

    @Override
    @XmlElement(name="linkage", required=true)
    public URI getLinkage() {
        return this.linkage;
    }

    public void setLinkage(URI newValue) {
        this.checkWritePermission();
        this.linkage = newValue;
    }

    @Override
    @XmlElement(name="protocol")
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String newValue) {
        this.checkWritePermission();
        this.protocol = newValue;
    }

    @UML(identifier="protocolRequest", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public String getProtocolRequest() {
        return this.protocolRequest;
    }

    public void setProtocolRequest(String newValue) {
        this.checkWritePermission();
        this.protocolRequest = newValue;
    }
}

