/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Series;
import org.opengis.util.InternationalString;

@XmlType(name="CI_Series_Type", propOrder={"name", "issueIdentification", "page"})
@XmlRootElement(name="CI_Series")
public class DefaultSeries
extends ISOMetadata
implements Series {
    private static final long serialVersionUID = 7061644572814855051L;
    private InternationalString name;
    private String issueIdentification;
    private String page;

    public DefaultSeries() {
    }

    public DefaultSeries(CharSequence name) {
        this.name = Types.toInternationalString(name);
    }

    public DefaultSeries(Series object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.issueIdentification = object.getIssueIdentification();
            this.page = object.getPage();
        }
    }

    public static DefaultSeries castOrCopy(Series object) {
        if (object == null || object instanceof DefaultSeries) {
            return (DefaultSeries)object;
        }
        return new DefaultSeries(object);
    }

    @Override
    @XmlElement(name="name")
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString newValue) {
        this.checkWritePermission();
        this.name = newValue;
    }

    @Override
    @XmlElement(name="issueIdentification")
    public String getIssueIdentification() {
        return this.issueIdentification;
    }

    public void setIssueIdentification(String newValue) {
        this.checkWritePermission();
        this.issueIdentification = newValue;
    }

    @Override
    @XmlElement(name="page")
    public String getPage() {
        return this.page;
    }

    public void setPage(String newValue) {
        this.checkWritePermission();
        this.page = newValue;
    }
}

