/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.constraint;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.metadata.iso.constraint.DefaultLegalConstraints;
import org.apache.sis.metadata.iso.constraint.DefaultReleasability;
import org.apache.sis.metadata.iso.constraint.DefaultSecurityConstraints;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.constraint.LegalConstraints;
import org.opengis.metadata.constraint.SecurityConstraints;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.quality.Scope;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Constraints_Type")
@XmlRootElement(name="MD_Constraints")
@XmlSeeAlso(value={DefaultLegalConstraints.class, DefaultSecurityConstraints.class})
public class DefaultConstraints
extends ISOMetadata
implements Constraints {
    private static final long serialVersionUID = -5622398793237824161L;
    private Collection<InternationalString> useLimitations;
    private Scope constraintApplicationScope;
    private Collection<BrowseGraphic> graphics;
    private Collection<Citation> references;
    private DefaultReleasability releasability;
    private Collection<DefaultResponsibility> responsibleParties;

    public DefaultConstraints() {
    }

    public DefaultConstraints(CharSequence useLimitation) {
        this.useLimitations = this.singleton(Types.toInternationalString(useLimitation), InternationalString.class);
    }

    public DefaultConstraints(Constraints object) {
        super(object);
        if (object != null) {
            this.useLimitations = this.copyCollection(object.getUseLimitations(), InternationalString.class);
            if (object instanceof DefaultConstraints) {
                DefaultConstraints c = (DefaultConstraints)object;
                this.constraintApplicationScope = c.getConstraintApplicationScope();
                this.graphics = this.copyCollection(c.getGraphics(), BrowseGraphic.class);
                this.references = this.copyCollection(c.getReferences(), Citation.class);
                this.releasability = c.getReleasability();
                this.responsibleParties = this.copyCollection(c.getResponsibleParties(), DefaultResponsibility.class);
            }
        }
    }

    public static DefaultConstraints castOrCopy(Constraints object) {
        if (object instanceof LegalConstraints) {
            return DefaultLegalConstraints.castOrCopy((LegalConstraints)object);
        }
        if (object instanceof SecurityConstraints) {
            return DefaultSecurityConstraints.castOrCopy((SecurityConstraints)object);
        }
        if (object == null || object instanceof DefaultConstraints) {
            return (DefaultConstraints)object;
        }
        return new DefaultConstraints(object);
    }

    @XmlElement(name="useLimitation")
    public Collection<InternationalString> getUseLimitations() {
        this.useLimitations = this.nonNullCollection(this.useLimitations, InternationalString.class);
        return this.useLimitations;
    }

    public void setUseLimitations(Collection<? extends InternationalString> newValues) {
        this.useLimitations = this.writeCollection(newValues, this.useLimitations, InternationalString.class);
    }

    @UML(identifier="constraintApplicationScope", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Scope getConstraintApplicationScope() {
        return this.constraintApplicationScope;
    }

    public void setConstraintApplicationScope(Scope newValue) {
        this.checkWritePermission();
        this.constraintApplicationScope = newValue;
    }

    @UML(identifier="graphic", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<BrowseGraphic> getGraphics() {
        this.graphics = this.nonNullCollection(this.graphics, BrowseGraphic.class);
        return this.graphics;
    }

    public void setGraphics(Collection<? extends BrowseGraphic> newValues) {
        this.graphics = this.writeCollection(newValues, this.graphics, BrowseGraphic.class);
    }

    @UML(identifier="reference", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getReferences() {
        this.references = this.nonNullCollection(this.references, Citation.class);
        return this.references;
    }

    public void setReferences(Collection<? extends Citation> newValues) {
        this.references = this.writeCollection(newValues, this.references, Citation.class);
    }

    @UML(identifier="releasability", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public DefaultReleasability getReleasability() {
        return this.releasability;
    }

    public void setReleasability(DefaultReleasability newValue) {
        this.checkWritePermission();
        this.releasability = newValue;
    }

    @UML(identifier="responsibleParty", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultResponsibility> getResponsibleParties() {
        this.responsibleParties = this.nonNullCollection(this.responsibleParties, DefaultResponsibility.class);
        return this.responsibleParties;
    }

    public void setResponsibleParties(Collection<? extends DefaultResponsibility> newValues) {
        this.responsibleParties = this.writeCollection(newValues, this.responsibleParties, DefaultResponsibility.class);
    }
}

