/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.RangeDimension;

@XmlType(name="MD_AttributeGroup_Type", propOrder={"contentType", "attribute"})
@XmlRootElement(name="MD_AttributeGroup")
@UML(identifier="MD_AttributeGroup", specification=Specification.ISO_19115)
public class DefaultAttributeGroup
extends ISOMetadata {
    private static final long serialVersionUID = -2198484393626051875L;
    private Collection<CoverageContentType> contentTypes;
    private Collection<RangeDimension> attributes;

    public DefaultAttributeGroup() {
    }

    public DefaultAttributeGroup(CoverageContentType contentType, RangeDimension attribute) {
        this.contentTypes = this.singleton(contentType, CoverageContentType.class);
        this.attributes = this.singleton(attribute, RangeDimension.class);
    }

    public DefaultAttributeGroup(DefaultAttributeGroup object) {
        super(object);
        if (object != null) {
            this.contentTypes = this.copyCollection(object.getContentTypes(), CoverageContentType.class);
            this.attributes = this.copyCollection(object.getAttributes(), RangeDimension.class);
        }
    }

    @XmlElement(name="contentType", required=true)
    @UML(identifier="contentType", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<CoverageContentType> getContentTypes() {
        this.contentTypes = this.nonNullCollection(this.contentTypes, CoverageContentType.class);
        return this.contentTypes;
    }

    public void setContentTypes(Collection<? extends CoverageContentType> newValues) {
        this.contentTypes = this.writeCollection(newValues, this.contentTypes, CoverageContentType.class);
    }

    @XmlElement(name="attribute")
    @UML(identifier="attribute", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<RangeDimension> getAttributes() {
        this.attributes = this.nonNullCollection(this.attributes, RangeDimension.class);
        return this.attributes;
    }

    public void setAttributes(Collection<? extends RangeDimension> newValues) {
        this.attributes = this.writeCollection(newValues, this.attributes, RangeDimension.class);
    }
}

