/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gmi.MI_Band;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.content.DefaultSampleDimension;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.BandDefinition;
import org.opengis.metadata.content.PolarizationOrientation;
import org.opengis.metadata.content.TransferFunctionType;

@XmlType(name="MD_Band_Type", propOrder={"peakResponse", "bitsPerValue", "toneGradation", "scaleFactor", "offset", "bandBoundaryDefinition", "nominalSpatialResolution", "transferFunctionType", "transmittedPolarization", "detectedPolarization"})
@XmlRootElement(name="MD_Band")
@XmlSeeAlso(value={MI_Band.class})
public class DefaultBand
extends DefaultSampleDimension
implements Band {
    private static final long serialVersionUID = -2474871120376144737L;
    private Double boundMin;
    private Double boundMax;
    private Unit<Length> boundUnits;
    private BandDefinition bandBoundaryDefinition;
    private Double peakResponse;
    private Integer toneGradation;
    private PolarizationOrientation transmittedPolarization;
    private PolarizationOrientation detectedPolarization;

    public DefaultBand() {
    }

    public DefaultBand(Band object) {
        super(object);
        if (object != null) {
            if (object instanceof DefaultBand) {
                DefaultBand c = (DefaultBand)object;
                this.boundMin = c.getBoundMin();
                this.boundMax = c.getBoundMax();
                this.boundUnits = c.getBoundUnits();
            }
            this.peakResponse = object.getPeakResponse();
            this.toneGradation = object.getToneGradation();
            this.bandBoundaryDefinition = object.getBandBoundaryDefinition();
            this.transmittedPolarization = object.getTransmittedPolarization();
            this.detectedPolarization = object.getDetectedPolarization();
        }
    }

    public static DefaultBand castOrCopy(Band object) {
        if (object == null || object instanceof DefaultBand) {
            return (DefaultBand)object;
        }
        return new DefaultBand(object);
    }

    @ValueRange(minimum=0.0)
    @UML(identifier="boundMin", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getBoundMin() {
        return this.boundMin;
    }

    public void setBoundMin(Double newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultBand.class, "boundMin", false, newValue)) {
            this.boundMin = newValue;
        }
    }

    @ValueRange(minimum=0.0)
    @UML(identifier="boundMax", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getBoundMax() {
        return this.boundMax;
    }

    public void setBoundMax(Double newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultBand.class, "boundMax", false, newValue)) {
            this.boundMax = newValue;
        }
    }

    @UML(identifier="boundUnits", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Unit<Length> getBoundUnits() {
        return this.boundUnits;
    }

    public void setBoundUnits(Unit<Length> newValue) {
        this.checkWritePermission();
        this.boundUnits = newValue;
    }

    @Override
    @XmlElement(name="bandBoundaryDefinition", namespace="http://www.isotc211.org/2005/gmi")
    public BandDefinition getBandBoundaryDefinition() {
        return this.bandBoundaryDefinition;
    }

    public void setBandBoundaryDefinition(BandDefinition newValue) {
        this.checkWritePermission();
        this.bandBoundaryDefinition = newValue;
    }

    @Override
    public Unit<Length> getUnits() {
        Unit<?> units = super.getUnits();
        return units != null ? units.asType(Length.class) : null;
    }

    @Override
    public void setUnits(Unit<?> newValue) {
        super.setUnits(newValue.asType(Length.class));
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="peakResponse")
    public Double getPeakResponse() {
        return this.peakResponse;
    }

    public void setPeakResponse(Double newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultBand.class, "peakResponse", false, newValue)) {
            this.peakResponse = newValue;
        }
    }

    @Override
    @ValueRange(minimum=1.0)
    @XmlElement(name="bitsPerValue")
    public Integer getBitsPerValue() {
        return super.getBitsPerValue();
    }

    @Override
    public void setBitsPerValue(Integer newValue) {
        super.setBitsPerValue(newValue);
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="toneGradation")
    public Integer getToneGradation() {
        return this.toneGradation;
    }

    public void setToneGradation(Integer newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultBand.class, "toneGradation", false, newValue)) {
            this.toneGradation = newValue;
        }
    }

    @Override
    @XmlElement(name="scaleFactor")
    public Double getScaleFactor() {
        return super.getScaleFactor();
    }

    @Override
    public void setScaleFactor(Double newValue) {
        super.setScaleFactor(newValue);
    }

    @Override
    @XmlElement(name="offset")
    public Double getOffset() {
        return super.getOffset();
    }

    @Override
    public void setOffset(Double newValue) {
        super.setOffset(newValue);
    }

    @Override
    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlElement(name="nominalSpatialResolution", namespace="http://www.isotc211.org/2005/gmi")
    public Double getNominalSpatialResolution() {
        return super.getNominalSpatialResolution();
    }

    @Override
    public void setNominalSpatialResolution(Double newValue) {
        super.setNominalSpatialResolution(newValue);
    }

    @Override
    @XmlElement(name="transferFunctionType", namespace="http://www.isotc211.org/2005/gmi")
    public TransferFunctionType getTransferFunctionType() {
        return super.getTransferFunctionType();
    }

    @Override
    public void setTransferFunctionType(TransferFunctionType newValue) {
        super.setTransferFunctionType(newValue);
    }

    @Override
    @XmlElement(name="transmittedPolarization", namespace="http://www.isotc211.org/2005/gmi")
    public PolarizationOrientation getTransmittedPolarization() {
        return this.transmittedPolarization;
    }

    public void setTransmittedPolarization(PolarizationOrientation newValue) {
        this.checkWritePermission();
        this.transmittedPolarization = newValue;
    }

    @Override
    @XmlElement(name="detectedPolarization", namespace="http://www.isotc211.org/2005/gmi")
    public PolarizationOrientation getDetectedPolarization() {
        return this.detectedPolarization;
    }

    public void setDetectedPolarization(PolarizationOrientation newValue) {
        this.checkWritePermission();
        this.detectedPolarization = newValue;
    }
}

