/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gmi.MI_CoverageDescription;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.content.AbstractContentInformation;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.CoverageDescription;
import org.opengis.metadata.content.ImageDescription;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.util.RecordType;

@XmlType(name="MD_CoverageDescription_Type", propOrder={"attributeDescription", "contentType", "dimensions", "rangeElementDescriptions"})
@XmlRootElement(name="MD_CoverageDescription")
@XmlSeeAlso(value={DefaultImageDescription.class, MI_CoverageDescription.class})
public class DefaultCoverageDescription
extends AbstractContentInformation
implements CoverageDescription {
    private static final long serialVersionUID = 2161065580202989466L;
    private RecordType attributeDescription;
    private Identifier processingLevelCode;
    private Collection<DefaultAttributeGroup> attributeGroups;
    private Collection<RangeElementDescription> rangeElementDescriptions;

    public DefaultCoverageDescription() {
    }

    public DefaultCoverageDescription(CoverageDescription object) {
        super(object);
        if (object != null) {
            this.attributeDescription = object.getAttributeDescription();
            this.rangeElementDescriptions = this.copyCollection(object.getRangeElementDescriptions(), RangeElementDescription.class);
            if (object instanceof DefaultCoverageDescription) {
                this.processingLevelCode = ((DefaultCoverageDescription)object).getProcessingLevelCode();
                this.attributeGroups = this.copyCollection(((DefaultCoverageDescription)object).getAttributeGroups(), DefaultAttributeGroup.class);
            }
        }
    }

    public static DefaultCoverageDescription castOrCopy(CoverageDescription object) {
        if (object instanceof ImageDescription) {
            return DefaultImageDescription.castOrCopy((ImageDescription)object);
        }
        if (object == null || object instanceof DefaultCoverageDescription) {
            return (DefaultCoverageDescription)object;
        }
        return new DefaultCoverageDescription(object);
    }

    @Override
    @XmlElement(name="attributeDescription", required=true)
    public RecordType getAttributeDescription() {
        return this.attributeDescription;
    }

    public void setAttributeDescription(RecordType newValue) {
        this.checkWritePermission();
        this.attributeDescription = newValue;
    }

    @UML(identifier="processingLevelCode", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getProcessingLevelCode() {
        return this.processingLevelCode;
    }

    public void setProcessingLevelCode(Identifier newValue) {
        this.checkWritePermission();
        this.processingLevelCode = newValue;
    }

    @UML(identifier="attributeGroup", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultAttributeGroup> getAttributeGroups() {
        this.attributeGroups = this.nonNullCollection(this.attributeGroups, DefaultAttributeGroup.class);
        return this.attributeGroups;
    }

    public void setAttributeGroups(Collection<? extends DefaultAttributeGroup> newValues) {
        this.attributeGroups = this.writeCollection(newValues, this.attributeGroups, DefaultAttributeGroup.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="contentType", required=true)
    public CoverageContentType getContentType() {
        CoverageContentType type = null;
        Collection<DefaultAttributeGroup> groups = this.getAttributeGroups();
        if (groups != null) {
            block0: for (DefaultAttributeGroup g : groups) {
                Collection<CoverageContentType> contentTypes = g.getContentTypes();
                if (contentTypes == null) continue;
                for (CoverageContentType t : contentTypes) {
                    if (type == null) {
                        type = t;
                        continue;
                    }
                    LegacyPropertyAdapter.warnIgnoredExtraneous(CoverageContentType.class, DefaultCoverageDescription.class, "getContentType");
                    continue block0;
                }
            }
        }
        return type;
    }

    @Deprecated
    public void setContentType(CoverageContentType newValue) {
        Iterator<DefaultAttributeGroup> iterator;
        this.checkWritePermission();
        Collection<CoverageContentType> newValues = LegacyPropertyAdapter.asCollection(newValue);
        Collection<DefaultAttributeGroup> groups = this.attributeGroups;
        if (groups != null && (iterator = groups.iterator()).hasNext()) {
            DefaultAttributeGroup group = iterator.next();
            group.setContentTypes(newValues);
            return;
        }
        DefaultAttributeGroup group = new DefaultAttributeGroup();
        group.setContentTypes(newValues);
        if (groups != null) {
            groups.add(group);
        } else {
            groups = Collections.singleton(group);
        }
        this.setAttributeGroups(groups);
    }

    @Deprecated
    @XmlElement(name="dimension")
    public final Collection<RangeDimension> getDimensions() {
        return new LegacyPropertyAdapter<RangeDimension, DefaultAttributeGroup>(this.getAttributeGroups()){

            @Override
            protected DefaultAttributeGroup wrap(RangeDimension value) {
                DefaultAttributeGroup container = new DefaultAttributeGroup();
                container.setAttributes(1.asCollection(value));
                return container;
            }

            @Override
            protected RangeDimension unwrap(DefaultAttributeGroup container) {
                return 1.getSingleton(container.getAttributes(), RangeDimension.class, this, DefaultCoverageDescription.class, "getDimensions");
            }

            @Override
            protected boolean update(DefaultAttributeGroup container, RangeDimension value) {
                if (container instanceof DefaultAttributeGroup) {
                    container.setAttributes(1.asCollection(value));
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setDimensions(Collection<? extends RangeDimension> newValues) {
        this.checkWritePermission();
        ((LegacyPropertyAdapter)this.getDimensions()).setValues(newValues);
    }

    @XmlElement(name="rangeElementDescription", namespace="http://www.isotc211.org/2005/gmi")
    public Collection<RangeElementDescription> getRangeElementDescriptions() {
        this.rangeElementDescriptions = this.nonNullCollection(this.rangeElementDescriptions, RangeElementDescription.class);
        return this.rangeElementDescriptions;
    }

    public void setRangeElementDescriptions(Collection<? extends RangeElementDescription> newValues) {
        this.rangeElementDescriptions = this.writeCollection(newValues, this.rangeElementDescriptions, RangeElementDescription.class);
    }
}

