/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import java.util.Collection;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.content.AbstractContentInformation;
import org.apache.sis.metadata.iso.content.DefaultFeatureTypeInfo;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.content.FeatureCatalogueDescription;
import org.opengis.util.GenericName;

@XmlType(name="MD_FeatureCatalogueDescription_Type", propOrder={"compliant", "languages", "includedWithDataset", "featureTypes", "featureCatalogueCitations"})
@XmlRootElement(name="MD_FeatureCatalogueDescription")
public class DefaultFeatureCatalogueDescription
extends AbstractContentInformation
implements FeatureCatalogueDescription {
    private static final long serialVersionUID = 5731044701122380718L;
    private Boolean compliant;
    private Collection<Locale> languages;
    private boolean includedWithDataset;
    private Collection<DefaultFeatureTypeInfo> featureTypes;
    private Collection<Citation> featureCatalogueCitations;

    public DefaultFeatureCatalogueDescription() {
    }

    public DefaultFeatureCatalogueDescription(FeatureCatalogueDescription object) {
        super(object);
        if (object != null) {
            this.compliant = object.isCompliant();
            this.includedWithDataset = object.isIncludedWithDataset();
            this.languages = this.copyCollection(object.getLanguages(), Locale.class);
            this.featureCatalogueCitations = this.copyCollection(object.getFeatureCatalogueCitations(), Citation.class);
            if (object instanceof DefaultFeatureCatalogueDescription) {
                this.featureTypes = this.copyCollection(((DefaultFeatureCatalogueDescription)object).getFeatureTypeInfo(), DefaultFeatureTypeInfo.class);
            } else {
                this.setFeatureTypes(object.getFeatureTypes());
            }
        }
    }

    public static DefaultFeatureCatalogueDescription castOrCopy(FeatureCatalogueDescription object) {
        if (object == null || object instanceof DefaultFeatureCatalogueDescription) {
            return (DefaultFeatureCatalogueDescription)object;
        }
        return new DefaultFeatureCatalogueDescription(object);
    }

    @Override
    @XmlElement(name="complianceCode")
    public Boolean isCompliant() {
        return this.compliant;
    }

    public void setCompliant(Boolean newValue) {
        this.checkWritePermission();
        this.compliant = newValue;
    }

    @Override
    @XmlElement(name="language")
    public Collection<Locale> getLanguages() {
        this.languages = this.nonNullCollection(this.languages, Locale.class);
        return this.languages;
    }

    public void setLanguages(Collection<? extends Locale> newValues) {
        this.languages = this.writeCollection(newValues, this.languages, Locale.class);
    }

    @Override
    @XmlElement(name="includedWithDataset", required=true)
    public boolean isIncludedWithDataset() {
        return this.includedWithDataset;
    }

    public void setIncludedWithDataset(boolean newValue) {
        this.checkWritePermission();
        this.includedWithDataset = newValue;
    }

    @UML(identifier="featureTypes", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultFeatureTypeInfo> getFeatureTypeInfo() {
        this.featureTypes = this.nonNullCollection(this.featureTypes, DefaultFeatureTypeInfo.class);
        return this.featureTypes;
    }

    public void setFeatureTypeInfo(Collection<? extends DefaultFeatureTypeInfo> newValues) {
        this.featureTypes = this.writeCollection(newValues, this.featureTypes, DefaultFeatureTypeInfo.class);
    }

    @Deprecated
    @XmlElement(name="featureTypes")
    public final Collection<GenericName> getFeatureTypes() {
        return new LegacyPropertyAdapter<GenericName, DefaultFeatureTypeInfo>(this.getFeatureTypeInfo()){

            @Override
            protected DefaultFeatureTypeInfo wrap(GenericName value) {
                return new DefaultFeatureTypeInfo(value);
            }

            @Override
            protected GenericName unwrap(DefaultFeatureTypeInfo container) {
                return container.getFeatureTypeName();
            }

            @Override
            protected boolean update(DefaultFeatureTypeInfo container, GenericName value) {
                if (container instanceof DefaultFeatureTypeInfo) {
                    container.setFeatureTypeName(value);
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setFeatureTypes(Collection<? extends GenericName> newValues) {
        this.checkWritePermission();
        ((LegacyPropertyAdapter)this.getFeatureTypes()).setValues(newValues);
    }

    @XmlElement(name="featureCatalogueCitation", required=true)
    public Collection<Citation> getFeatureCatalogueCitations() {
        this.featureCatalogueCitations = this.nonNullCollection(this.featureCatalogueCitations, Citation.class);
        return this.featureCatalogueCitations;
    }

    public void setFeatureCatalogueCitations(Collection<? extends Citation> newValues) {
        this.featureCatalogueCitations = this.writeCollection(newValues, this.featureCatalogueCitations, Citation.class);
    }
}

