/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gmi.MI_ImageDescription;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.content.DefaultCoverageDescription;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.content.ImageDescription;
import org.opengis.metadata.content.ImagingCondition;

@XmlType(name="MD_ImageDescription_Type", propOrder={"illuminationElevationAngle", "illuminationAzimuthAngle", "imagingCondition", "imageQualityCode", "cloudCoverPercentage", "processingLevelCode", "compressionGenerationQuantity", "triangulationIndicator", "radiometricCalibrationDataAvailable", "cameraCalibrationInformationAvailable", "filmDistortionInformationAvailable", "lensDistortionInformationAvailable"})
@XmlRootElement(name="MD_ImageDescription")
@XmlSeeAlso(value={MI_ImageDescription.class})
public class DefaultImageDescription
extends DefaultCoverageDescription
implements ImageDescription {
    private static final long serialVersionUID = -239683653229623567L;
    private Double illuminationElevationAngle;
    private Double illuminationAzimuthAngle;
    private ImagingCondition imagingCondition;
    private Identifier imageQualityCode;
    private Double cloudCoverPercentage;
    private Integer compressionGenerationQuantity;
    private Boolean triangulationIndicator;
    private Boolean radiometricCalibrationDataAvailable;
    private Boolean cameraCalibrationInformationAvailable;
    private Boolean filmDistortionInformationAvailable;
    private Boolean lensDistortionInformationAvailable;

    public DefaultImageDescription() {
    }

    public DefaultImageDescription(ImageDescription object) {
        super(object);
        if (object != null) {
            this.illuminationElevationAngle = object.getIlluminationElevationAngle();
            this.illuminationAzimuthAngle = object.getIlluminationAzimuthAngle();
            this.imagingCondition = object.getImagingCondition();
            this.imageQualityCode = object.getImageQualityCode();
            this.cloudCoverPercentage = object.getCloudCoverPercentage();
            this.compressionGenerationQuantity = object.getCompressionGenerationQuantity();
            this.triangulationIndicator = object.getTriangulationIndicator();
            this.radiometricCalibrationDataAvailable = object.isRadiometricCalibrationDataAvailable();
            this.cameraCalibrationInformationAvailable = object.isCameraCalibrationInformationAvailable();
            this.filmDistortionInformationAvailable = object.isFilmDistortionInformationAvailable();
            this.lensDistortionInformationAvailable = object.isLensDistortionInformationAvailable();
        }
    }

    public static DefaultImageDescription castOrCopy(ImageDescription object) {
        if (object == null || object instanceof DefaultImageDescription) {
            return (DefaultImageDescription)object;
        }
        return new DefaultImageDescription(object);
    }

    @Override
    @ValueRange(minimum=-90.0, maximum=90.0)
    @XmlElement(name="illuminationElevationAngle")
    public Double getIlluminationElevationAngle() {
        return this.illuminationElevationAngle;
    }

    public void setIlluminationElevationAngle(Double newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensureInRange(DefaultImageDescription.class, "illuminationElevationAngle", -90, 90, newValue)) {
            this.illuminationElevationAngle = newValue;
        }
    }

    @Override
    @ValueRange(minimum=0.0, maximum=360.0)
    @XmlElement(name="illuminationAzimuthAngle")
    public Double getIlluminationAzimuthAngle() {
        return this.illuminationAzimuthAngle;
    }

    public void setIlluminationAzimuthAngle(Double newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensureInRange(DefaultImageDescription.class, "illuminationAzimuthAngle", 0, 360, newValue)) {
            this.illuminationAzimuthAngle = newValue;
        }
    }

    @Override
    @XmlElement(name="imagingCondition")
    public ImagingCondition getImagingCondition() {
        return this.imagingCondition;
    }

    public void setImagingCondition(ImagingCondition newValue) {
        this.checkWritePermission();
        this.imagingCondition = newValue;
    }

    @Override
    @XmlElement(name="imageQualityCode")
    public Identifier getImageQualityCode() {
        return this.imageQualityCode;
    }

    public void setImageQualityCode(Identifier newValue) {
        this.checkWritePermission();
        this.imageQualityCode = newValue;
    }

    @Override
    @ValueRange(minimum=0.0, maximum=100.0)
    @XmlElement(name="cloudCoverPercentage")
    public Double getCloudCoverPercentage() {
        return this.cloudCoverPercentage;
    }

    public void setCloudCoverPercentage(Double newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensureInRange(DefaultImageDescription.class, "cloudCoverPercentage", 0, 100, newValue)) {
            this.cloudCoverPercentage = newValue;
        }
    }

    @Override
    @XmlElement(name="processingLevelCode")
    public Identifier getProcessingLevelCode() {
        return super.getProcessingLevelCode();
    }

    @Override
    public void setProcessingLevelCode(Identifier newValue) {
        super.setProcessingLevelCode(newValue);
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="compressionGenerationQuantity")
    public Integer getCompressionGenerationQuantity() {
        return this.compressionGenerationQuantity;
    }

    public void setCompressionGenerationQuantity(Integer newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultImageDescription.class, "compressionGenerationQuantity", false, newValue)) {
            this.compressionGenerationQuantity = newValue;
        }
    }

    @Override
    @XmlElement(name="triangulationIndicator")
    public Boolean getTriangulationIndicator() {
        return this.triangulationIndicator;
    }

    public void setTriangulationIndicator(Boolean newValue) {
        this.checkWritePermission();
        this.triangulationIndicator = newValue;
    }

    @Override
    @XmlElement(name="radiometricCalibrationDataAvailability")
    public Boolean isRadiometricCalibrationDataAvailable() {
        return this.radiometricCalibrationDataAvailable;
    }

    public void setRadiometricCalibrationDataAvailable(Boolean newValue) {
        this.checkWritePermission();
        this.radiometricCalibrationDataAvailable = newValue;
    }

    @Override
    @XmlElement(name="cameraCalibrationInformationAvailability")
    public Boolean isCameraCalibrationInformationAvailable() {
        return this.cameraCalibrationInformationAvailable;
    }

    public void setCameraCalibrationInformationAvailable(Boolean newValue) {
        this.checkWritePermission();
        this.cameraCalibrationInformationAvailable = newValue;
    }

    @Override
    @XmlElement(name="filmDistortionInformationAvailability")
    public Boolean isFilmDistortionInformationAvailable() {
        return this.filmDistortionInformationAvailable;
    }

    public void setFilmDistortionInformationAvailable(Boolean newValue) {
        this.checkWritePermission();
        this.filmDistortionInformationAvailable = newValue;
    }

    @Override
    @XmlElement(name="lensDistortionInformationAvailability")
    public Boolean isLensDistortionInformationAvailable() {
        return this.lensDistortionInformationAvailable;
    }

    public void setLensDistortionInformationAvailable(Boolean newValue) {
        this.checkWritePermission();
        this.lensDistortionInformationAvailable = newValue;
    }
}

