/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultRangeDimension;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlType(name="MD_SampleDimension_Type", propOrder={"maxValue", "minValue", "units"})
@XmlRootElement(name="MD_SampleDimension")
@XmlSeeAlso(value={DefaultBand.class, DefaultRangeDimension.class})
@UML(identifier="MD_SampleDimension", specification=Specification.ISO_19115)
public class DefaultSampleDimension
extends DefaultRangeDimension {
    private static final long serialVersionUID = 4517148689016920767L;
    private Double minValue;
    private Double maxValue;
    private Double meanValue;
    private Integer numberOfValues;
    private Double standardDeviation;
    private Unit<?> units;
    private Double scaleFactor;
    private Double offset;
    private TransferFunctionType transferFunctionType;
    private Integer bitsPerValue;
    private Double nominalSpatialResolution;
    private RecordType otherPropertyType;
    private Record otherProperty;

    public DefaultSampleDimension() {
    }

    public DefaultSampleDimension(DefaultSampleDimension object) {
        super(object);
        if (object != null) {
            this.init(object);
        }
    }

    private void init(DefaultSampleDimension object) {
        this.minValue = object.getMinValue();
        this.maxValue = object.getMaxValue();
        this.meanValue = object.getMeanValue();
        this.numberOfValues = object.getNumberOfValues();
        this.standardDeviation = object.getStandardDeviation();
        this.units = object.getUnits();
        this.scaleFactor = object.getScaleFactor();
        this.offset = object.getOffset();
        this.transferFunctionType = object.getTransferFunctionType();
        this.bitsPerValue = object.getBitsPerValue();
        this.nominalSpatialResolution = object.getNominalSpatialResolution();
        this.otherPropertyType = object.getOtherPropertyType();
        this.otherProperty = object.getOtherProperty();
    }

    DefaultSampleDimension(Band object) {
        super(object);
        if (object != null) {
            if (object instanceof DefaultSampleDimension) {
                this.init((DefaultSampleDimension)((Object)object));
            } else {
                this.maxValue = object.getMaxValue();
                this.minValue = object.getMinValue();
                this.units = object.getUnits();
                this.scaleFactor = object.getScaleFactor();
                this.offset = object.getOffset();
                this.bitsPerValue = object.getBitsPerValue();
            }
        }
    }

    @XmlElement(name="minValue")
    @UML(identifier="minValue", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Double newValue) {
        this.checkWritePermission();
        this.minValue = newValue;
    }

    @XmlElement(name="maxValue")
    @UML(identifier="maxValue", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Double newValue) {
        this.checkWritePermission();
        this.maxValue = newValue;
    }

    @UML(identifier="meanValue", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getMeanValue() {
        return this.meanValue;
    }

    public void setMeanValue(Double newValue) {
        this.checkWritePermission();
        this.meanValue = newValue;
    }

    @ValueRange(minimum=0.0)
    @UML(identifier="numberOfValues", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Integer getNumberOfValues() {
        return this.numberOfValues;
    }

    public void setNumberOfValues(Integer newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultSampleDimension.class, "numberOfValues", false, newValue)) {
            this.numberOfValues = newValue;
        }
    }

    @UML(identifier="standardDeviation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(Double newValue) {
        this.checkWritePermission();
        this.standardDeviation = newValue;
    }

    @XmlElement(name="units")
    @UML(identifier="units", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Unit<?> getUnits() {
        return this.units;
    }

    public void setUnits(Unit<?> newValue) {
        this.checkWritePermission();
        this.units = newValue;
    }

    @UML(identifier="scaleFactor", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(Double newValue) {
        this.checkWritePermission();
        this.scaleFactor = newValue;
    }

    @UML(identifier="offset", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getOffset() {
        return this.offset;
    }

    public void setOffset(Double newValue) {
        this.checkWritePermission();
        this.offset = newValue;
    }

    public TransferFunctionType getTransferFunctionType() {
        return this.transferFunctionType;
    }

    public void setTransferFunctionType(TransferFunctionType newValue) {
        this.checkWritePermission();
        this.transferFunctionType = newValue;
    }

    @ValueRange(minimum=1.0)
    @UML(identifier="bitsPerValue", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Integer getBitsPerValue() {
        return this.bitsPerValue;
    }

    public void setBitsPerValue(Integer newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultSampleDimension.class, "bitsPerValue", true, newValue)) {
            this.bitsPerValue = newValue;
        }
    }

    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getNominalSpatialResolution() {
        return this.nominalSpatialResolution;
    }

    public void setNominalSpatialResolution(Double newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultSampleDimension.class, "nominalSpatialResolution", true, newValue)) {
            this.nominalSpatialResolution = newValue;
        }
    }

    @UML(identifier="otherPropertyType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public RecordType getOtherPropertyType() {
        return this.otherPropertyType;
    }

    public void setOtherPropertyType(RecordType newValue) {
        this.checkWritePermission();
        this.otherPropertyType = newValue;
    }

    @UML(identifier="otherProperty", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Record getOtherProperty() {
        return this.otherProperty;
    }

    public void setOtherProperty(Record newValue) {
        this.checkWritePermission();
        this.otherProperty = newValue;
    }
}

