/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.distribution.Medium;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

@XmlType(name="MD_DigitalTransferOptions_Type", propOrder={"unitsOfDistribution", "transferSize", "onLines", "offLine"})
@XmlRootElement(name="MD_DigitalTransferOptions")
public class DefaultDigitalTransferOptions
extends ISOMetadata
implements DigitalTransferOptions {
    private static final long serialVersionUID = -2901375920581273330L;
    private InternationalString unitsOfDistribution;
    private Double transferSize;
    private Collection<OnlineResource> onLines;
    private Collection<Medium> offLines;
    private PeriodDuration transferFrequency;
    private Collection<Format> distributionFormats;

    public DefaultDigitalTransferOptions() {
    }

    public DefaultDigitalTransferOptions(DigitalTransferOptions object) {
        super(object);
        if (object != null) {
            this.unitsOfDistribution = object.getUnitsOfDistribution();
            this.transferSize = object.getTransferSize();
            this.onLines = this.copyCollection(object.getOnLines(), OnlineResource.class);
            if (object instanceof DefaultDigitalTransferOptions) {
                DefaultDigitalTransferOptions c = (DefaultDigitalTransferOptions)object;
                this.offLines = this.copyCollection(c.getOffLines(), Medium.class);
                this.transferFrequency = c.getTransferFrequency();
                this.distributionFormats = this.copyCollection(c.getDistributionFormats(), Format.class);
            } else {
                this.offLines = this.singleton(object.getOffLine(), Medium.class);
            }
        }
    }

    public static DefaultDigitalTransferOptions castOrCopy(DigitalTransferOptions object) {
        if (object == null || object instanceof DefaultDigitalTransferOptions) {
            return (DefaultDigitalTransferOptions)object;
        }
        return new DefaultDigitalTransferOptions(object);
    }

    @Override
    @XmlElement(name="unitsOfDistribution")
    public InternationalString getUnitsOfDistribution() {
        return this.unitsOfDistribution;
    }

    public void setUnitsOfDistribution(InternationalString newValue) {
        this.checkWritePermission();
        this.unitsOfDistribution = newValue;
    }

    @Override
    @XmlElement(name="transferSize")
    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getTransferSize() {
        return this.transferSize;
    }

    public void setTransferSize(Double newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultDigitalTransferOptions.class, "transferSize", true, newValue)) {
            this.transferSize = newValue;
        }
    }

    @XmlElement(name="onLine")
    public Collection<OnlineResource> getOnLines() {
        this.onLines = this.nonNullCollection(this.onLines, OnlineResource.class);
        return this.onLines;
    }

    public void setOnLines(Collection<? extends OnlineResource> newValues) {
        this.onLines = this.writeCollection(newValues, this.onLines, OnlineResource.class);
    }

    @UML(identifier="offLine", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Medium> getOffLines() {
        this.offLines = this.nonNullCollection(this.offLines, Medium.class);
        return this.offLines;
    }

    public void setOffLines(Collection<? extends Medium> newValues) {
        this.offLines = this.writeCollection(newValues, this.offLines, Medium.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="offLine")
    public Medium getOffLine() {
        return LegacyPropertyAdapter.getSingleton(this.getOffLines(), Medium.class, null, DefaultDigitalTransferOptions.class, "getOffLine");
    }

    @Deprecated
    public void setOffLine(Medium newValue) {
        this.setOffLines(LegacyPropertyAdapter.asCollection(newValue));
    }

    @UML(identifier="transferFrequency", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public PeriodDuration getTransferFrequency() {
        return this.transferFrequency;
    }

    public void setTransferFrequency(PeriodDuration newValue) {
        this.checkWritePermission();
        this.transferFrequency = newValue;
    }

    @UML(identifier="distributionFormat", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Format> getDistributionFormats() {
        this.distributionFormats = this.nonNullCollection(this.distributionFormats, Format.class);
        return this.distributionFormats;
    }

    public void setDistributionFormats(Collection<? extends Format> newValues) {
        this.distributionFormats = this.writeCollection(newValues, this.distributionFormats, Format.class);
    }
}

