/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jdk8.BiConsumer;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.Distributor;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.distribution.Medium;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Format_Type", propOrder={"name", "version", "amendmentNumber", "specification", "fileDecompressionTechnique", "formatDistributors"})
@XmlRootElement(name="MD_Format")
public class DefaultFormat
extends ISOMetadata
implements Format {
    private static final long serialVersionUID = -8346373589075887348L;
    private Citation formatSpecificationCitation;
    private InternationalString amendmentNumber;
    private InternationalString fileDecompressionTechnique;
    private Collection<Medium> media;
    private Collection<Distributor> formatDistributors;

    public DefaultFormat() {
    }

    public DefaultFormat(CharSequence name, CharSequence version) {
        DefaultCitation citation = new DefaultCitation();
        if (name != null) {
            citation.setAlternateTitles(Collections.singleton(Types.toInternationalString(name)));
        }
        citation.setEdition(Types.toInternationalString(version));
        this.formatSpecificationCitation = citation;
    }

    public DefaultFormat(Format object) {
        super(object);
        if (object != null) {
            this.amendmentNumber = object.getAmendmentNumber();
            this.fileDecompressionTechnique = object.getFileDecompressionTechnique();
            this.formatDistributors = this.copyCollection(object.getFormatDistributors(), Distributor.class);
            if (object instanceof DefaultFormat) {
                this.formatSpecificationCitation = ((DefaultFormat)object).getFormatSpecificationCitation();
                this.media = this.copyCollection(((DefaultFormat)object).getMedia(), Medium.class);
            } else {
                this.setSpecification(object.getSpecification());
                this.setVersion(object.getVersion());
                this.setName(object.getName());
            }
        }
    }

    public static DefaultFormat castOrCopy(Format object) {
        if (object == null || object instanceof DefaultFormat) {
            return (DefaultFormat)object;
        }
        return new DefaultFormat(object);
    }

    @UML(identifier="formatSpecificationCitation", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Citation getFormatSpecificationCitation() {
        return this.formatSpecificationCitation;
    }

    public void setFormatSpecificationCitation(Citation newValue) {
        this.checkWritePermission();
        this.formatSpecificationCitation = newValue;
    }

    private <T> void setFormatSpecificationCitation(BiConsumer<DefaultCitation, T> setter, T value) {
        Citation citation = this.formatSpecificationCitation;
        if (citation != null || value != null) {
            if (!(citation instanceof DefaultCitation)) {
                citation = new DefaultCitation(citation);
            }
            setter.accept((DefaultCitation)citation, (DefaultCitation)value);
            if (value == null && ((DefaultCitation)citation).isEmpty()) {
                citation = null;
            }
        }
        if (citation != this.formatSpecificationCitation) {
            this.setFormatSpecificationCitation(citation);
        }
    }

    @Override
    @Deprecated
    @XmlElement(name="specification")
    public InternationalString getSpecification() {
        Citation citation = this.getFormatSpecificationCitation();
        return citation != null ? citation.getTitle() : null;
    }

    @Deprecated
    public void setSpecification(InternationalString newValue) {
        this.checkWritePermission();
        this.setFormatSpecificationCitation(new BiConsumer<DefaultCitation, InternationalString>(){

            @Override
            public void accept(DefaultCitation citation, InternationalString value) {
                citation.setTitle(value);
            }
        }, newValue);
    }

    @Override
    @Deprecated
    @XmlElement(name="name", required=true)
    public InternationalString getName() {
        Citation citation = this.getFormatSpecificationCitation();
        if (citation != null) {
            return LegacyPropertyAdapter.getSingleton(citation.getAlternateTitles(), InternationalString.class, null, DefaultFormat.class, "getName");
        }
        return null;
    }

    @Deprecated
    public void setName(InternationalString newValue) {
        this.checkWritePermission();
        this.setFormatSpecificationCitation(new BiConsumer<DefaultCitation, InternationalString>(){

            @Override
            public void accept(DefaultCitation citation, InternationalString value) {
                citation.setAlternateTitles(LegacyPropertyAdapter.asCollection(value));
            }
        }, newValue);
    }

    @Override
    @Deprecated
    @XmlElement(name="version", required=true)
    public InternationalString getVersion() {
        Citation citation = this.getFormatSpecificationCitation();
        return citation != null ? citation.getEdition() : null;
    }

    @Deprecated
    public void setVersion(InternationalString newValue) {
        this.checkWritePermission();
        this.setFormatSpecificationCitation(new BiConsumer<DefaultCitation, InternationalString>(){

            @Override
            public void accept(DefaultCitation citation, InternationalString value) {
                citation.setEdition(value);
            }
        }, newValue);
    }

    @Override
    @XmlElement(name="amendmentNumber")
    public InternationalString getAmendmentNumber() {
        return this.amendmentNumber;
    }

    public void setAmendmentNumber(InternationalString newValue) {
        this.checkWritePermission();
        this.amendmentNumber = newValue;
    }

    @Override
    @XmlElement(name="fileDecompressionTechnique")
    public InternationalString getFileDecompressionTechnique() {
        return this.fileDecompressionTechnique;
    }

    public void setFileDecompressionTechnique(InternationalString newValue) {
        this.checkWritePermission();
        this.fileDecompressionTechnique = newValue;
    }

    @UML(identifier="medium", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Medium> getMedia() {
        this.media = this.nonNullCollection(this.media, Medium.class);
        return this.media;
    }

    public void setMedia(Collection<? extends Medium> newValues) {
        this.media = this.writeCollection(newValues, this.media, Medium.class);
    }

    @XmlElement(name="formatDistributor")
    public Collection<Distributor> getFormatDistributors() {
        this.formatDistributors = this.nonNullCollection(this.formatDistributors, Distributor.class);
        return this.formatDistributors;
    }

    public void setFormatDistributors(Collection<? extends Distributor> newValues) {
        this.formatDistributors = this.writeCollection(newValues, this.formatDistributors, Distributor.class);
    }
}

