/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Collection;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.distribution.Medium;
import org.opengis.metadata.distribution.MediumFormat;
import org.opengis.metadata.distribution.MediumName;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Medium_Type", propOrder={"name", "densities", "densityUnits", "volumes", "mediumFormats", "mediumNote"})
@XmlRootElement(name="MD_Medium")
public class DefaultMedium
extends ISOMetadata
implements Medium {
    private static final long serialVersionUID = 7751002701087451894L;
    private MediumName name;
    private Collection<Double> densities;
    private Unit<?> densityUnits;
    private Integer volumes;
    private Collection<MediumFormat> mediumFormats;
    private InternationalString mediumNote;

    public DefaultMedium() {
    }

    public DefaultMedium(Medium object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.densities = this.copyCollection(object.getDensities(), Double.class);
            this.densityUnits = object.getDensityUnits();
            this.volumes = object.getVolumes();
            this.mediumFormats = this.copyCollection(object.getMediumFormats(), MediumFormat.class);
            this.mediumNote = object.getMediumNote();
            if (object instanceof DefaultMedium) {
                this.identifiers = this.singleton(((DefaultMedium)object).getIdentifier(), Identifier.class);
            }
        }
    }

    public static DefaultMedium castOrCopy(Medium object) {
        if (object == null || object instanceof DefaultMedium) {
            return (DefaultMedium)object;
        }
        return new DefaultMedium(object);
    }

    @Override
    @XmlElement(name="name")
    public MediumName getName() {
        return this.name;
    }

    public void setName(MediumName newValue) {
        this.checkWritePermission();
        this.name = newValue;
    }

    @ValueRange(minimum=0.0, isMinIncluded=false)
    @UML(identifier="density", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getDensity() {
        return LegacyPropertyAdapter.getSingleton(this.densities, Double.class, null, DefaultMedium.class, "getDensity");
    }

    public void setDensity(Double newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultMedium.class, "density", true, newValue)) {
            this.densities = this.writeCollection(LegacyPropertyAdapter.asCollection(newValue), this.densities, Double.class);
        }
    }

    @Override
    @Deprecated
    @XmlElement(name="density")
    public Collection<Double> getDensities() {
        this.densities = this.nonNullCollection(this.densities, Double.class);
        return this.densities;
    }

    @Deprecated
    public void setDensities(Collection<? extends Double> newValues) {
        this.densities = this.writeCollection(newValues, this.densities, Double.class);
    }

    @Override
    @XmlElement(name="densityUnits")
    public Unit<?> getDensityUnits() {
        return this.densityUnits;
    }

    public void setDensityUnits(Unit<?> newValue) {
        this.checkWritePermission();
        this.densityUnits = newValue;
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="volumes")
    public Integer getVolumes() {
        return this.volumes;
    }

    public void setVolumes(Integer newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultMedium.class, "volumes", false, newValue)) {
            this.volumes = newValue;
        }
    }

    @Override
    @XmlElement(name="mediumFormat")
    public Collection<MediumFormat> getMediumFormats() {
        this.mediumFormats = this.nonNullCollection(this.mediumFormats, MediumFormat.class);
        return this.mediumFormats;
    }

    public void setMediumFormats(Collection<? extends MediumFormat> newValues) {
        this.mediumFormats = this.writeCollection(newValues, this.mediumFormats, MediumFormat.class);
    }

    @Override
    @XmlElement(name="mediumNote")
    public InternationalString getMediumNote() {
        return this.mediumNote;
    }

    public void setMediumNote(InternationalString newValue) {
        this.checkWritePermission();
        this.mediumNote = newValue;
    }

    @UML(identifier="identifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getIdentifier() {
        return NonMarshalledAuthority.getMarshallable(this.identifiers);
    }

    public void setIdentifier(Identifier newValue) {
        this.checkWritePermission();
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        NonMarshalledAuthority.setMarshallable(this.identifiers, newValue);
    }
}

