/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Currency;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.distribution.StandardOrderProcess;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlType(name="MD_StandardOrderProcess_Type", propOrder={"fees", "plannedAvailableDateTime", "orderingInstructions", "turnaround"})
@XmlRootElement(name="MD_StandardOrderProcess")
public class DefaultStandardOrderProcess
extends ISOMetadata
implements StandardOrderProcess {
    private static final long serialVersionUID = 6107884863471045743L;
    private InternationalString fees;
    private Currency currency;
    private long plannedAvailableDateTime = Long.MIN_VALUE;
    private InternationalString orderingInstructions;
    private InternationalString turnaround;
    private RecordType orderOptionType;
    private Record orderOptions;

    public DefaultStandardOrderProcess() {
    }

    public DefaultStandardOrderProcess(StandardOrderProcess object) {
        super(object);
        if (object != null) {
            this.fees = object.getFees();
            this.plannedAvailableDateTime = MetadataUtilities.toMilliseconds(object.getPlannedAvailableDateTime());
            this.orderingInstructions = object.getOrderingInstructions();
            this.turnaround = object.getTurnaround();
            if (object instanceof DefaultStandardOrderProcess) {
                this.orderOptionType = ((DefaultStandardOrderProcess)object).getOrderOptionType();
                this.orderOptions = ((DefaultStandardOrderProcess)object).getOrderOptions();
            }
        }
    }

    public static DefaultStandardOrderProcess castOrCopy(StandardOrderProcess object) {
        if (object == null || object instanceof DefaultStandardOrderProcess) {
            return (DefaultStandardOrderProcess)object;
        }
        return new DefaultStandardOrderProcess(object);
    }

    @Override
    @XmlElement(name="fees")
    public InternationalString getFees() {
        return this.fees;
    }

    public void setFees(InternationalString newValue) {
        this.checkWritePermission();
        this.fees = newValue;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency newValue) {
        this.checkWritePermission();
        this.currency = newValue;
    }

    @Override
    @XmlElement(name="plannedAvailableDateTime")
    public Date getPlannedAvailableDateTime() {
        return MetadataUtilities.toDate(this.plannedAvailableDateTime);
    }

    public void setPlannedAvailableDateTime(Date newValue) {
        this.checkWritePermission();
        this.plannedAvailableDateTime = MetadataUtilities.toMilliseconds(newValue);
    }

    @Override
    @XmlElement(name="orderingInstructions")
    public InternationalString getOrderingInstructions() {
        return this.orderingInstructions;
    }

    public void setOrderingInstructions(InternationalString newValue) {
        this.checkWritePermission();
        this.orderingInstructions = newValue;
    }

    @Override
    @XmlElement(name="turnaround")
    public InternationalString getTurnaround() {
        return this.turnaround;
    }

    public void setTurnaround(InternationalString newValue) {
        this.checkWritePermission();
        this.turnaround = newValue;
    }

    @UML(identifier="orderOptionType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public RecordType getOrderOptionType() {
        return this.orderOptionType;
    }

    public void setOrderOptionType(RecordType newValue) {
        this.checkWritePermission();
        this.orderOptionType = newValue;
    }

    @UML(identifier="orderOptions", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Record getOrderOptions() {
        return this.orderOptions;
    }

    public void setOrderOptions(Record newValue) {
        this.checkWritePermission();
        this.orderOptions = newValue;
    }
}

