/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

@XmlType(name="EX_Extent_Type", propOrder={"description", "geographicElements", "temporalElements", "verticalElements"})
@XmlRootElement(name="EX_Extent")
public class DefaultExtent
extends ISOMetadata
implements Extent {
    private static final long serialVersionUID = 2979058128422252800L;
    private InternationalString description;
    private Collection<GeographicExtent> geographicElements;
    private Collection<VerticalExtent> verticalElements;
    private Collection<TemporalExtent> temporalElements;

    public DefaultExtent() {
    }

    public DefaultExtent(CharSequence description, GeographicExtent geographicElements, VerticalExtent verticalElements, TemporalExtent temporalElements) {
        this.description = Types.toInternationalString(description);
        this.geographicElements = this.singleton(geographicElements, GeographicExtent.class);
        this.verticalElements = this.singleton(verticalElements, VerticalExtent.class);
        this.temporalElements = this.singleton(temporalElements, TemporalExtent.class);
    }

    public DefaultExtent(Extent object) {
        super(object);
        if (object != null) {
            this.description = object.getDescription();
            this.geographicElements = this.copyCollection(object.getGeographicElements(), GeographicExtent.class);
            this.temporalElements = this.copyCollection(object.getTemporalElements(), TemporalExtent.class);
            this.verticalElements = this.copyCollection(object.getVerticalElements(), VerticalExtent.class);
        }
    }

    public static DefaultExtent castOrCopy(Extent object) {
        if (object == null || object instanceof DefaultExtent) {
            return (DefaultExtent)object;
        }
        return new DefaultExtent(object);
    }

    @Override
    @XmlElement(name="description")
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    @XmlElement(name="geographicElement")
    public Collection<GeographicExtent> getGeographicElements() {
        this.geographicElements = this.nonNullCollection(this.geographicElements, GeographicExtent.class);
        return this.geographicElements;
    }

    public void setGeographicElements(Collection<? extends GeographicExtent> newValues) {
        this.geographicElements = this.writeCollection(newValues, this.geographicElements, GeographicExtent.class);
    }

    @XmlElement(name="verticalElement")
    public Collection<VerticalExtent> getVerticalElements() {
        this.verticalElements = this.nonNullCollection(this.verticalElements, VerticalExtent.class);
        return this.verticalElements;
    }

    public void setVerticalElements(Collection<? extends VerticalExtent> newValues) {
        this.verticalElements = this.writeCollection(newValues, this.verticalElements, VerticalExtent.class);
    }

    @XmlElement(name="temporalElement")
    public Collection<TemporalExtent> getTemporalElements() {
        this.temporalElements = this.nonNullCollection(this.temporalElements, TemporalExtent.class);
        return this.temporalElements;
    }

    public void setTemporalElements(Collection<? extends TemporalExtent> newValues) {
        this.temporalElements = this.writeCollection(newValues, this.temporalElements, TemporalExtent.class);
    }

    public void addElements(Envelope envelope) throws TransformException {
        this.checkWritePermission();
        ReferencingServices.getInstance().addElements(envelope, this);
    }
}

