/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.geoapi.temporal.Instant;
import org.apache.sis.internal.geoapi.temporal.Period;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.SpatialTemporalExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.referencing.operation.TransformException;
import org.opengis.temporal.TemporalPrimitive;

@XmlType(name="EX_TemporalExtent_Type")
@XmlRootElement(name="EX_TemporalExtent")
@XmlSeeAlso(value={DefaultSpatialTemporalExtent.class})
public class DefaultTemporalExtent
extends ISOMetadata
implements TemporalExtent {
    private static final long serialVersionUID = -6149873501105795242L;
    private TemporalPrimitive extent;

    public DefaultTemporalExtent() {
    }

    public DefaultTemporalExtent(TemporalExtent object) {
        super(object);
        if (object != null) {
            this.extent = object.getExtent();
        }
    }

    public static DefaultTemporalExtent castOrCopy(TemporalExtent object) {
        if (object instanceof SpatialTemporalExtent) {
            return DefaultSpatialTemporalExtent.castOrCopy((SpatialTemporalExtent)object);
        }
        if (object == null || object instanceof DefaultTemporalExtent) {
            return (DefaultTemporalExtent)object;
        }
        return new DefaultTemporalExtent(object);
    }

    @Override
    @XmlElement(name="extent", required=true)
    public TemporalPrimitive getExtent() {
        return this.extent;
    }

    public void setExtent(TemporalPrimitive newValue) {
        this.checkWritePermission();
        this.extent = newValue;
    }

    static Date getTime(TemporalPrimitive extent, boolean begin) {
        Instant instant;
        if (extent instanceof Instant) {
            instant = (Instant)extent;
        } else if (extent instanceof Period) {
            instant = begin ? ((Period)extent).getBeginning() : ((Period)extent).getEnding();
        } else {
            return null;
        }
        return instant.getDate();
    }

    public Date getStartTime() {
        return DefaultTemporalExtent.getTime(this.extent, true);
    }

    public Date getEndTime() {
        return DefaultTemporalExtent.getTime(this.extent, false);
    }

    public void setBounds(Date startTime, Date endTime) throws UnsupportedOperationException {
        TemporalPrimitive value = null;
        if (startTime != null || endTime != null) {
            value = endTime == null || endTime.equals(startTime) ? TemporalUtilities.createInstant(startTime) : (startTime == null ? TemporalUtilities.createInstant(endTime) : TemporalUtilities.createPeriod(startTime, endTime));
        }
        this.setExtent(value);
    }

    public void setBounds(Envelope envelope) throws TransformException {
        this.checkWritePermission();
        ReferencingServices.getInstance().setBounds(envelope, this);
    }
}

