/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.GO_Real;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.TransformException;

@XmlType(name="EX_VerticalExtent_Type", propOrder={"minimumValue", "maximumValue", "verticalCRS"})
@XmlRootElement(name="EX_VerticalExtent")
public class DefaultVerticalExtent
extends ISOMetadata
implements VerticalExtent {
    private static final long serialVersionUID = -1963873471175296153L;
    private Double minimumValue;
    private Double maximumValue;
    private VerticalCRS verticalCRS;

    public DefaultVerticalExtent() {
    }

    public DefaultVerticalExtent(double minimumValue, double maximumValue, VerticalCRS verticalCRS) {
        if (!Double.isNaN(minimumValue)) {
            this.minimumValue = minimumValue;
        }
        if (!Double.isNaN(maximumValue)) {
            this.maximumValue = maximumValue;
        }
        this.verticalCRS = verticalCRS;
    }

    public DefaultVerticalExtent(VerticalExtent object) {
        super(object);
        if (object != null) {
            this.minimumValue = object.getMinimumValue();
            this.maximumValue = object.getMaximumValue();
            this.verticalCRS = object.getVerticalCRS();
        }
    }

    public static DefaultVerticalExtent castOrCopy(VerticalExtent object) {
        if (object == null || object instanceof DefaultVerticalExtent) {
            return (DefaultVerticalExtent)object;
        }
        return new DefaultVerticalExtent(object);
    }

    @Override
    @XmlElement(name="minimumValue", required=true)
    @XmlJavaTypeAdapter(value=GO_Real.class)
    public Double getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(Double newValue) {
        this.checkWritePermission();
        this.minimumValue = newValue;
    }

    @Override
    @XmlElement(name="maximumValue", required=true)
    @XmlJavaTypeAdapter(value=GO_Real.class)
    public Double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(Double newValue) {
        this.checkWritePermission();
        this.maximumValue = newValue;
    }

    @Override
    @XmlElement(name="verticalCRS", required=true)
    public VerticalCRS getVerticalCRS() {
        return this.verticalCRS;
    }

    public void setVerticalCRS(VerticalCRS newValue) {
        this.checkWritePermission();
        this.verticalCRS = newValue;
    }

    public void setBounds(Envelope envelope) throws TransformException {
        this.checkWritePermission();
        ReferencingServices.getInstance().setBounds(envelope, this);
    }
}

