/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.util.Date;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.temporal.TemporalPrimitive;

public final class Extents
extends Static {
    public static final Extent WORLD;

    private Extents() {
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Extent extent) {
        GeographicBoundingBox candidate = null;
        if (extent != null) {
            DefaultGeographicBoundingBox modifiable = null;
            for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                if (!(geographicExtent instanceof GeographicBoundingBox)) {
                    if (!(geographicExtent instanceof BoundingPolygon)) continue;
                    continue;
                }
                GeographicBoundingBox bounds = (GeographicBoundingBox)geographicExtent;
                if (candidate == null) {
                    if (!MetadataUtilities.getInclusion(bounds.getInclusion())) continue;
                    candidate = bounds;
                    continue;
                }
                if (modifiable == null) {
                    modifiable = new DefaultGeographicBoundingBox();
                    modifiable.setBounds(candidate);
                    candidate = modifiable;
                }
                modifiable.add(bounds);
            }
        }
        return candidate;
    }

    public static MeasurementRange<Double> getVerticalRange(Extent extent) {
        MeasurementRange range = null;
        VerticalDatumType selectedType = null;
        if (extent != null) {
            for (VerticalExtent verticalExtent : extent.getVerticalElements()) {
                double min = verticalExtent.getMinimumValue();
                double max = verticalExtent.getMaximumValue();
                VerticalCRS crs = verticalExtent.getVerticalCRS();
                VerticalDatumType type = null;
                Unit<?> unit = null;
                if (crs != null) {
                    VerticalDatum datum = crs.getDatum();
                    if (datum != null && VerticalDatumType.DEPTH.equals(type = datum.getVerticalDatumType())) {
                        type = VerticalDatumType.GEOIDAL;
                    }
                    CoordinateSystemAxis axis = crs.getCoordinateSystem().getAxis(0);
                    unit = axis.getUnit();
                    if (AxisDirection.DOWN.equals(axis.getDirection())) {
                        double tmp = min;
                        min = -max;
                        max = -tmp;
                    }
                }
                if (range != null) {
                    Unit<?> previous;
                    if (type == null || unit == null) continue;
                    if (!type.equals(selectedType)) {
                        if (!type.equals(VerticalDatumType.GEOIDAL)) {
                            continue;
                        }
                    } else if (selectedType != null && (previous = range.unit()) != null) {
                        if (!previous.isCompatible(unit)) continue;
                        range = (MeasurementRange)range.union(MeasurementRange.create(min, true, max, true, unit));
                        continue;
                    }
                }
                range = MeasurementRange.create(min, true, max, true, unit);
                selectedType = type;
            }
        }
        return range;
    }

    public static Range<Date> getTimeRange(Extent extent) {
        Date min = null;
        Date max = null;
        if (extent != null) {
            for (TemporalExtent temporalExtent : extent.getTemporalElements()) {
                Date endTime;
                Date startTime;
                if (temporalExtent instanceof DefaultTemporalExtent) {
                    DefaultTemporalExtent dt = (DefaultTemporalExtent)temporalExtent;
                    startTime = dt.getStartTime();
                    endTime = dt.getEndTime();
                } else {
                    TemporalPrimitive p = temporalExtent.getExtent();
                    startTime = DefaultTemporalExtent.getTime(p, true);
                    endTime = DefaultTemporalExtent.getTime(p, false);
                }
                if (startTime != null && (min == null || startTime.before(min))) {
                    min = startTime;
                }
                if (endTime == null || max != null && !endTime.after(max)) continue;
                max = endTime;
            }
        }
        if (min == null && max == null) {
            return null;
        }
        return new Range<Object>((Class<Object>)Date.class, min, true, max, true);
    }

    public static Date getDate(Extent extent, double location) {
        ArgumentChecks.ensureFinite("location", location);
        Date min = null;
        Date max = null;
        if (extent != null) {
            for (TemporalExtent temporalExtent : extent.getTemporalElements()) {
                Date startTime = null;
                Date endTime = null;
                if (temporalExtent instanceof DefaultTemporalExtent) {
                    DefaultTemporalExtent dt = (DefaultTemporalExtent)temporalExtent;
                    if (location != 1.0) {
                        startTime = dt.getStartTime();
                    }
                    if (location != 0.0) {
                        endTime = dt.getEndTime();
                    }
                } else {
                    TemporalPrimitive p = temporalExtent.getExtent();
                    if (location != 1.0) {
                        startTime = DefaultTemporalExtent.getTime(p, true);
                    }
                    if (location != 0.0) {
                        endTime = DefaultTemporalExtent.getTime(p, false);
                    }
                }
                if (startTime != null && (min == null || startTime.before(min))) {
                    min = startTime;
                }
                if (endTime == null || max != null && !endTime.after(max)) continue;
                max = endTime;
            }
        }
        if (min == null) {
            return max;
        }
        if (max == null) {
            return min;
        }
        long startTime = min.getTime();
        return new Date(startTime + Math.round((double)(max.getTime() - startTime) * location));
    }

    public static GeographicBoundingBox intersection(GeographicBoundingBox b1, GeographicBoundingBox b2) {
        if (b1 == null) {
            return b2;
        }
        if (b2 == null || b2 == b1) {
            return b1;
        }
        DefaultGeographicBoundingBox box = new DefaultGeographicBoundingBox(b1);
        box.intersect(b2);
        return box;
    }

    public static double area(GeographicBoundingBox box) {
        if (box == null) {
            return Double.NaN;
        }
        double \u0394\u03bb = box.getEastBoundLongitude() - box.getWestBoundLongitude();
        \u0394\u03bb -= Math.floor(\u0394\u03bb / 360.0) * 360.0;
        return 4.0589730194049E13 * Math.toRadians(\u0394\u03bb) * Math.max(0.0, Math.sin(Math.toRadians(box.getNorthBoundLatitude())) - Math.sin(Math.toRadians(box.getSouthBoundLatitude())));
    }

    static {
        DefaultGeographicBoundingBox box = new DefaultGeographicBoundingBox(-180.0, 180.0, -90.0, 90.0);
        box.freeze();
        DefaultExtent world = new DefaultExtent(Vocabulary.formatInternational((short)64), box, null, null);
        world.freeze();
        WORLD = world;
    }
}

