/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.AggregateInformation;
import org.opengis.metadata.identification.AssociationType;
import org.opengis.metadata.identification.InitiativeType;

@XmlType(name="MD_AssociatedResource_Type")
@XmlRootElement(name="MD_AssociatedResource")
@UML(identifier="MD_AssociatedResource", specification=Specification.ISO_19115)
public class DefaultAssociatedResource
extends ISOMetadata {
    private static final long serialVersionUID = -803259032236939135L;
    private Citation name;
    private AssociationType associationType;
    private InitiativeType initiativeType;
    private Citation metadataReference;

    public DefaultAssociatedResource() {
    }

    public DefaultAssociatedResource(Citation name, AssociationType associationType) {
        this.name = name;
        this.associationType = associationType;
    }

    DefaultAssociatedResource(DefaultAssociatedResource object) {
        this.associationType = object.associationType;
        this.initiativeType = object.initiativeType;
        this.name = object.name;
        this.metadataReference = object.metadataReference;
    }

    DefaultAssociatedResource(AggregateInformation object) {
        if (object != null) {
            this.associationType = object.getAssociationType();
            this.initiativeType = object.getInitiativeType();
            if (object instanceof DefaultAssociatedResource) {
                this.name = ((DefaultAssociatedResource)((Object)object)).getName();
                this.metadataReference = ((DefaultAssociatedResource)((Object)object)).getMetadataReference();
            }
        }
    }

    static DefaultAssociatedResource castOrCopy(AggregateInformation object) {
        if (object == null || object instanceof DefaultAssociatedResource) {
            return (DefaultAssociatedResource)((Object)object);
        }
        return new DefaultAssociatedResource(object);
    }

    @UML(identifier="name", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Citation getName() {
        return this.name;
    }

    public void setName(Citation newValue) {
        this.checkWritePermission();
        this.name = newValue;
    }

    @UML(identifier="associationType", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(AssociationType newValue) {
        this.checkWritePermission();
        this.associationType = newValue;
    }

    @UML(identifier="initiativeType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InitiativeType getInitiativeType() {
        return this.initiativeType;
    }

    public void setInitiativeType(InitiativeType newValue) {
        this.checkWritePermission();
        this.initiativeType = newValue;
    }

    @UML(identifier="metadataReference", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Citation getMetadataReference() {
        return this.metadataReference;
    }

    public void setMetadataReference(Citation newValue) {
        this.checkWritePermission();
        this.metadataReference = newValue;
    }
}

