/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.net.URI;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gmx.MimeFileTypeAdapter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.util.InternationalString;

@XmlType(name="MD_BrowseGraphic_Type", propOrder={"fileName", "fileDescription", "fileType"})
@XmlRootElement(name="MD_BrowseGraphic")
public class DefaultBrowseGraphic
extends ISOMetadata
implements BrowseGraphic {
    private static final long serialVersionUID = 1769063690091153678L;
    private URI fileName;
    private InternationalString fileDescription;
    private String fileType;
    private Collection<Constraints> imageConstraints;
    private Collection<OnlineResource> linkages;

    public DefaultBrowseGraphic() {
    }

    public DefaultBrowseGraphic(URI fileName) {
        this.fileName = fileName;
    }

    public DefaultBrowseGraphic(BrowseGraphic object) {
        super(object);
        if (object != null) {
            this.fileName = object.getFileName();
            this.fileDescription = object.getFileDescription();
            this.fileType = object.getFileType();
            if (object instanceof DefaultBrowseGraphic) {
                this.imageConstraints = ((DefaultBrowseGraphic)object).getImageConstraints();
                this.linkages = ((DefaultBrowseGraphic)object).getLinkages();
            }
        }
    }

    public static DefaultBrowseGraphic castOrCopy(BrowseGraphic object) {
        if (object == null || object instanceof DefaultBrowseGraphic) {
            return (DefaultBrowseGraphic)object;
        }
        return new DefaultBrowseGraphic(object);
    }

    @Override
    @XmlElement(name="fileName", required=true)
    public URI getFileName() {
        return this.fileName;
    }

    public void setFileName(URI newValue) {
        this.checkWritePermission();
        this.fileName = newValue;
    }

    @Override
    @XmlElement(name="fileDescription")
    public InternationalString getFileDescription() {
        return this.fileDescription;
    }

    public void setFileDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.fileDescription = newValue;
    }

    @Override
    @XmlElement(name="fileType")
    @XmlJavaTypeAdapter(value=MimeFileTypeAdapter.class)
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String newValue) {
        this.checkWritePermission();
        this.fileType = newValue;
    }

    @UML(identifier="imageContraints", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Constraints> getImageConstraints() {
        this.imageConstraints = this.nonNullCollection(this.imageConstraints, Constraints.class);
        return this.imageConstraints;
    }

    public void setImageConstraints(Collection<? extends Constraints> newValues) {
        this.imageConstraints = this.writeCollection(newValues, this.imageConstraints, Constraints.class);
    }

    @UML(identifier="linkage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<OnlineResource> getLinkages() {
        this.linkages = this.nonNullCollection(this.linkages, OnlineResource.class);
        return this.linkages;
    }

    public void setLinkages(Collection<? extends OnlineResource> newValues) {
        this.linkages = this.writeCollection(newValues, this.linkages, OnlineResource.class);
    }
}

