/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.util.InternationalString;

@XmlType(name="MD_DataIdentification_Type", propOrder={"languages", "characterSets", "topicCategory", "environmentDescription", "extent", "supplementalInformation"})
@XmlRootElement(name="MD_DataIdentification")
public class DefaultDataIdentification
extends AbstractIdentification
implements DataIdentification {
    private static final long serialVersionUID = 6104637930243499850L;
    private Collection<Locale> languages;
    private Collection<CharacterSet> characterSets;
    private InternationalString environmentDescription;
    private InternationalString supplementalInformation;

    public DefaultDataIdentification() {
    }

    public DefaultDataIdentification(Citation citation, CharSequence abstracts, Locale language, TopicCategory topicCategory) {
        super(citation, abstracts);
        this.languages = this.singleton(language, Locale.class);
        super.setTopicCategories(this.singleton(topicCategory, TopicCategory.class));
    }

    public DefaultDataIdentification(DataIdentification object) {
        super(object);
        if (object != null) {
            this.languages = this.copyCollection(object.getLanguages(), Locale.class);
            this.characterSets = this.copyCollection(object.getCharacterSets(), CharacterSet.class);
            this.environmentDescription = object.getEnvironmentDescription();
            this.supplementalInformation = object.getSupplementalInformation();
        }
    }

    public static DefaultDataIdentification castOrCopy(DataIdentification object) {
        if (object == null || object instanceof DefaultDataIdentification) {
            return (DefaultDataIdentification)object;
        }
        return new DefaultDataIdentification(object);
    }

    @Override
    @XmlElement(name="language", required=true)
    public Collection<Locale> getLanguages() {
        this.languages = this.nonNullCollection(this.languages, Locale.class);
        return this.languages;
    }

    public void setLanguages(Collection<? extends Locale> newValues) {
        this.languages = this.writeCollection(newValues, this.languages, Locale.class);
    }

    @Override
    @XmlElement(name="characterSet")
    public Collection<CharacterSet> getCharacterSets() {
        this.characterSets = this.nonNullCollection(this.characterSets, CharacterSet.class);
        return this.characterSets;
    }

    public void setCharacterSets(Collection<? extends CharacterSet> newValues) {
        this.characterSets = this.writeCollection(newValues, this.characterSets, CharacterSet.class);
    }

    @Override
    @XmlElement(name="environmentDescription")
    public InternationalString getEnvironmentDescription() {
        return this.environmentDescription;
    }

    public void setEnvironmentDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.environmentDescription = newValue;
    }

    @Override
    @XmlElement(name="supplementalInformation")
    public InternationalString getSupplementalInformation() {
        return this.supplementalInformation;
    }

    public void setSupplementalInformation(InternationalString newValue) {
        this.checkWritePermission();
        this.supplementalInformation = newValue;
    }

    @XmlElement(name="topicCategory")
    private Collection<TopicCategory> getTopicCategory() {
        return this.getTopicCategories();
    }

    private void setTopicCategory(Collection<? extends TopicCategory> newValues) {
        this.setTopicCategories(newValues);
    }

    @XmlElement(name="extent")
    private Collection<Extent> getExtent() {
        return this.getExtents();
    }

    private void setExtent(Collection<? extends Extent> newValues) {
        this.setExtents(newValues);
    }
}

