/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.net.URI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.InternationalString;

@XmlType(name="MD_KeywordClass_Type", propOrder={"className", "conceptIdentifier", "ontology"})
@XmlRootElement(name="MD_KeywordClass")
public class DefaultKeywordClass
extends ISOMetadata {
    private static final long serialVersionUID = 5353835680916000713L;
    private InternationalString className;
    private URI conceptIdentifier;
    private Citation ontology;

    public DefaultKeywordClass() {
    }

    public DefaultKeywordClass(CharSequence className, Citation ontology) {
        this.className = Types.toInternationalString(className);
        this.ontology = ontology;
    }

    public DefaultKeywordClass(DefaultKeywordClass object) {
        super(object);
        if (object != null) {
            this.className = object.getClassName();
            this.conceptIdentifier = object.getConceptIdentifier();
            this.ontology = object.getOntology();
        }
    }

    @XmlElement(name="className", required=true)
    public InternationalString getClassName() {
        return this.className;
    }

    public void setClassName(InternationalString newValue) {
        this.checkWritePermission();
        this.className = newValue;
    }

    @XmlElement(name="conceptIdentifier")
    public URI getConceptIdentifier() {
        return this.conceptIdentifier;
    }

    public void setConceptIdentifier(URI newValue) {
        this.checkWritePermission();
        this.conceptIdentifier = newValue;
    }

    @XmlElement(name="ontology", required=true)
    public Citation getOntology() {
        return this.ontology;
    }

    public void setOntology(Citation newValue) {
        this.checkWritePermission();
        this.ontology = newValue;
    }
}

