/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.Keywords;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Keywords_Type", propOrder={"keywords", "type", "thesaurusName"})
@XmlRootElement(name="MD_Keywords")
public class DefaultKeywords
extends ISOMetadata
implements Keywords {
    private static final long serialVersionUID = -2765705888428016211L;
    private Collection<InternationalString> keywords;
    private KeywordType type;
    private Citation thesaurusName;
    private CodeList<?> keywordClass;

    public DefaultKeywords() {
    }

    public DefaultKeywords(CharSequence ... keywords) {
        if (keywords != null) {
            for (CharSequence keyword : keywords) {
                InternationalString i18n = Types.toInternationalString(keyword);
                if (this.keywords == null) {
                    this.keywords = this.singleton(i18n, InternationalString.class);
                    continue;
                }
                this.keywords.add(i18n);
            }
        }
    }

    public DefaultKeywords(Keywords object) {
        super(object);
        if (object != null) {
            this.keywords = this.copyCollection(object.getKeywords(), InternationalString.class);
            this.type = object.getType();
            this.thesaurusName = object.getThesaurusName();
        }
    }

    public static DefaultKeywords castOrCopy(Keywords object) {
        if (object == null || object instanceof DefaultKeywords) {
            return (DefaultKeywords)object;
        }
        return new DefaultKeywords(object);
    }

    @XmlElement(name="keyword", required=true)
    public Collection<InternationalString> getKeywords() {
        this.keywords = this.nonNullCollection(this.keywords, InternationalString.class);
        return this.keywords;
    }

    public void setKeywords(Collection<? extends InternationalString> newValues) {
        this.keywords = this.writeCollection(newValues, this.keywords, InternationalString.class);
    }

    @Override
    @XmlElement(name="type")
    public KeywordType getType() {
        return this.type;
    }

    public void setType(KeywordType newValue) {
        this.checkWritePermission();
        this.type = newValue;
    }

    @Override
    @XmlElement(name="thesaurusName")
    public Citation getThesaurusName() {
        return this.thesaurusName;
    }

    public void setThesaurusName(Citation newValue) {
        this.checkWritePermission();
        this.thesaurusName = newValue;
    }

    @UML(identifier="keywordClass", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public CodeList<?> getKeywordClass() {
        return this.keywordClass;
    }

    public void setKeywordClass(CodeList<?> newValue) {
        this.checkWritePermission();
        this.keywordClass = newValue;
    }
}

